/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.SingletonOutputWriterFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ServerListBuilder {
    @Nonnull
    private final Map<Server, TemporaryServer> servers = Maps.newHashMap();
    @Nonnull
    private final Map<OutputWriterFactory, OutputWriterFactory> outputWriters = Maps.newHashMap();

    public ServerListBuilder add(Iterable<Server> servers) {
        for (Server server : servers) {
            this.add(server);
        }
        return this;
    }

    private void add(Server server) {
        TemporaryServer temporaryServer = this.singleton(server);
        temporaryServer.addQueries((Iterable<Query>)server.getQueries());
        temporaryServer.addOutputWriters((Iterable<OutputWriterFactory>)server.getOutputWriterFactories());
    }

    private TemporaryServer singleton(Server server) {
        if (!this.servers.containsKey(server)) {
            this.servers.put(server, new TemporaryServer(server));
        }
        return this.servers.get(server);
    }

    private OutputWriterFactory singleton(OutputWriterFactory outputWriter) {
        if (!this.outputWriters.containsKey(outputWriter = new SingletonOutputWriterFactory(outputWriter))) {
            this.outputWriters.put(outputWriter, outputWriter);
        }
        return this.outputWriters.get(outputWriter);
    }

    public ImmutableList<Server> build() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemporaryServer server : this.servers.values()) {
            builder.add((Object)server.build());
        }
        return builder.build();
    }

    private Collection<OutputWriter> createOutputWriters(@Nonnull Set<OutputWriterFactory> outputWriterFactories) {
        return FluentIterable.from(outputWriterFactories).transform((Function)new Function<OutputWriterFactory, OutputWriter>(){

            @Nullable
            public OutputWriter apply(OutputWriterFactory input) {
                return input.create();
            }
        }).toList();
    }

    private class TemporaryServer {
        @Nonnull
        private final Server server;
        @Nonnull
        private final Map<Query, Set<OutputWriterFactory>> queries = Maps.newHashMap();
        @Nonnull
        private final Set<OutputWriterFactory> temporaryOutputWriters = Sets.newHashSet();

        TemporaryServer(Server server) {
            this.server = server;
        }

        public void addQueries(@Nonnull Iterable<Query> queries) {
            for (Query query : queries) {
                this.addQuery(query);
            }
        }

        private void addQuery(@Nonnull Query query) {
            if (!this.queries.containsKey(query)) {
                this.queries.put(query, new HashSet());
            }
            Set<OutputWriterFactory> outputWritersForThisQuery = this.queries.get(query);
            for (OutputWriterFactory outputWriter : query.getOutputWriters()) {
                outputWritersForThisQuery.add(ServerListBuilder.this.singleton(outputWriter));
            }
        }

        public void addOutputWriters(@Nonnull Iterable<OutputWriterFactory> outputWriters) {
            for (OutputWriterFactory outputWriter : outputWriters) {
                this.temporaryOutputWriters.add(ServerListBuilder.this.singleton(outputWriter));
            }
        }

        public Server build() {
            Server.Builder builder = Server.builder(this.server).addOutputWriters(ServerListBuilder.this.createOutputWriters(this.temporaryOutputWriters)).clearQueries();
            for (Map.Entry<Query, Set<OutputWriterFactory>> queryEntry : this.queries.entrySet()) {
                builder.addQuery(Query.builder(queryEntry.getKey()).addOutputWriters(ServerListBuilder.this.createOutputWriters(queryEntry.getValue())).build());
            }
            return builder.build();
        }
    }
}

