/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularDataSupport;

public class JmxResultProcessor {
    private final Query query;
    private final ObjectInstance objectInstance;
    private final String className;
    private final String objDomain;
    private final List<Attribute> attributes;

    public JmxResultProcessor(Query query, ObjectInstance objectInstance, List<Attribute> attributes, String className, String objDomain) {
        this.query = query;
        this.objectInstance = objectInstance;
        this.className = className;
        this.objDomain = objDomain;
        this.attributes = attributes;
    }

    public ImmutableList<Result> getResults() {
        ImmutableList.Builder accumulator = ImmutableList.builder();
        for (Attribute attribute : this.attributes) {
            this.getResult((ImmutableList.Builder<Result>)accumulator, attribute);
        }
        return accumulator.build();
    }

    private void getResult(ImmutableList.Builder<Result> accumulator, Attribute attribute) {
        Object value = attribute.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof CompositeData) {
            this.getResult(accumulator, attribute.getName(), (CompositeData)value);
        } else if (value instanceof CompositeData[]) {
            for (CompositeData cd : (CompositeData[])value) {
                this.getResult(accumulator, attribute.getName(), cd);
            }
        } else if (value instanceof ObjectName[]) {
            HashMap values = Maps.newHashMap();
            for (ObjectName obj : (ObjectName[])value) {
                values.put(obj.getCanonicalName(), obj.getKeyPropertyListString());
            }
            Result r = this.getNewResultObject(attribute.getName(), values);
            accumulator.add((Object)r);
        } else if (value.getClass().isArray()) {
            HashMap values = Maps.newHashMap();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object val = Array.get(value, i);
                values.put(attribute.getName() + "." + i, val);
            }
            accumulator.add((Object)this.getNewResultObject(attribute.getName(), values));
        } else if (value instanceof TabularDataSupport) {
            TabularDataSupport tds = (TabularDataSupport)value;
            Map<String, Object> values = Collections.emptyMap();
            Result r = this.getNewResultObject(attribute.getName(), values);
            this.processTabularDataSupport(accumulator, attribute.getName(), tds);
            accumulator.add((Object)r);
        } else if (value instanceof Map) {
            Result r = this.getNewResultObject(attribute.getName(), (Map<String, Object>)this.convertKeysToString((Map)value));
            accumulator.add((Object)r);
        } else {
            HashMap values = Maps.newHashMap();
            values.put(attribute.getName(), value);
            Result r = this.getNewResultObject(attribute.getName(), values);
            accumulator.add((Object)r);
        }
    }

    private <K, V> ImmutableMap<String, V> convertKeysToString(Map<K, V> value) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<K, V> entry : value.entrySet()) {
            values.put((Object)entry.getKey().toString(), entry.getValue());
        }
        return values.build();
    }

    private void getResult(ImmutableList.Builder<Result> accumulator, String attributeName, CompositeData cds) {
        CompositeType t = cds.getCompositeType();
        HashMap values = Maps.newHashMap();
        Set<String> keys = t.keySet();
        for (String key : keys) {
            Object value = cds.get(key);
            if (value instanceof TabularDataSupport) {
                TabularDataSupport tds = (TabularDataSupport)value;
                this.processTabularDataSupport(accumulator, attributeName + "." + key, tds);
                continue;
            }
            if (value instanceof CompositeDataSupport) {
                CompositeDataSupport cds2 = (CompositeDataSupport)value;
                this.getResult(accumulator, attributeName, cds2);
                return;
            }
            values.put(key, value);
        }
        Result r = this.getNewResultObject(attributeName, values);
        accumulator.add((Object)r);
    }

    private void processTabularDataSupport(ImmutableList.Builder<Result> accumulator, String attributeName, TabularDataSupport tds) {
        Set<Map.Entry<Object, Object>> entries = tds.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object entryKeys = entry.getKey();
            if (entryKeys instanceof List) {
                StringBuilder sb = new StringBuilder();
                for (Object entryKey : (List)entryKeys) {
                    sb.append(".");
                    sb.append(entryKey);
                }
                String attributeName2 = sb.toString();
                Object entryValue = entry.getValue();
                if (entryValue instanceof CompositeDataSupport) {
                    this.getResult(accumulator, attributeName + attributeName2, (CompositeDataSupport)entryValue);
                    continue;
                }
                throw new RuntimeException("!!!!!!!!!! Please file a bug: https://github.com/jmxtrans/jmxtrans/issues entryValue is: " + entryValue.getClass().getCanonicalName());
            }
            throw new RuntimeException("!!!!!!!!!! Please file a bug: https://github.com/jmxtrans/jmxtrans/issues entryKeys is: " + entryKeys.getClass().getCanonicalName());
        }
    }

    private Result getNewResultObject(String attributeName, Map<String, Object> values) {
        return new Result(System.currentTimeMillis(), attributeName, this.className, this.objDomain, this.query.getResultAlias(), this.objectInstance.getObjectName().getKeyPropertyListString(), values);
    }
}

