/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.inject.Inject;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.util.PlaceholderResolverJsonNodeFactory;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JsonUtils {
    @Nonnull
    private final ObjectMapper mapper;

    @Inject
    public JsonUtils(@Nonnull ObjectMapper mapper, @Nonnull PlaceholderResolverJsonNodeFactory placeholderResolverJsonNodeFactory) {
        this.mapper = mapper;
        this.mapper.setNodeFactory((JsonNodeFactory)placeholderResolverJsonNodeFactory);
    }

    public JmxProcess parseProcess(File file) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(file);
        JmxProcess jmx = (JmxProcess)this.mapper.treeToValue((TreeNode)jsonNode, JmxProcess.class);
        jmx.setName(file.getName());
        return jmx;
    }
}

