/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultProcessor {
    private final Logger logger = LoggerFactory.getLogger(ResultProcessor.class);
    @Nonnull
    private final ThreadPoolExecutor executorService;

    @Inject
    public ResultProcessor(@Named(value="resultProcessorExecutor") @Nonnull ThreadPoolExecutor executorService) {
        this.executorService = executorService;
    }

    public void submit(final @Nonnull Server server, final @Nonnull Query query, final @Nonnull Iterable<Result> results) {
        for (final OutputWriter writer : Iterables.concat(query.getOutputWriterInstances(), server.getOutputWriters())) {
            try {
                this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            writer.doWrite(server, query, results);
                        }
                        catch (Exception e) {
                            ResultProcessor.this.logger.warn("Could not write results {} of query {} to output writer {}", new Object[]{results, query, writer, e});
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                this.logger.error("Could not submit results {} of query {} to output writer {}. You could try to size the 'resultProcessorExecutor' to a larger size.", new Object[]{results, query, writer, ree});
            }
        }
    }
}

