/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.googlecode.jmxtrans.cli.CliArgumentParser;
import com.googlecode.jmxtrans.cli.FileConfiguration;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;

public class JCommanderArgumentParser
implements CliArgumentParser {
    @Override
    @Nonnull
    public JmxTransConfiguration parseOptions(@Nonnull String[] args) throws IOException {
        JmxTransConfiguration tempConfig = new JmxTransConfiguration();
        JmxTransConfiguration configuration = new JmxTransConfiguration();
        new JCommander((Object)tempConfig, args);
        JCommander jCommander = new JCommander();
        jCommander.setDefaultProvider((IDefaultProvider)new FileConfiguration(this.localProperties(tempConfig.getConfigFile())));
        jCommander.addObject((Object)configuration);
        jCommander.parse(args);
        if (configuration.isHelp()) {
            jCommander.usage();
        } else {
            this.validate(configuration);
        }
        return configuration;
    }

    private Properties localProperties(File configFile) throws IOException {
        Properties properties = new Properties(this.defaultProperties());
        File defaultSystemProperties = new File("/etc/jmxtrans/jmxtrans.properties");
        if (configFile != null) {
            try (FileInputStream in = new FileInputStream(configFile);){
                properties.load(in);
            }
        }
        if (defaultSystemProperties.isFile()) {
            try (FileInputStream in = new FileInputStream(defaultSystemProperties);){
                properties.load(in);
            }
        }
        return properties;
    }

    private Properties defaultProperties() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("jmxtrans.properties");){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private void validate(JmxTransConfiguration configuration) {
        if (configuration.getJsonDirOrFile() == null) {
            throw new ParameterException("Please specify either the -f or -j option.");
        }
    }
}

