/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.inject.Inject;
import com.googlecode.jmxtrans.guice.JsonFormat;
import com.googlecode.jmxtrans.guice.YamlFormat;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.util.PlaceholderResolverJsonNodeFactory;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ProcessConfigUtils {
    @Nonnull
    private final ObjectMapper jsonMapper;
    @Nonnull
    private final ObjectMapper yamlMapper;

    @Inject
    public ProcessConfigUtils(@Nonnull @JsonFormat ObjectMapper jsonMapper, @Nonnull @YamlFormat ObjectMapper yamlMapper, @Nonnull PlaceholderResolverJsonNodeFactory placeholderResolverJsonNodeFactory) {
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
        this.jsonMapper.setNodeFactory((JsonNodeFactory)placeholderResolverJsonNodeFactory);
        this.yamlMapper.setNodeFactory((JsonNodeFactory)placeholderResolverJsonNodeFactory);
    }

    public JmxProcess parseProcess(File file) throws IOException {
        ObjectMapper mapper = file.getName().endsWith(".yml") || file.getName().endsWith(".yaml") ? this.yamlMapper : this.jsonMapper;
        JsonNode jsonNode = mapper.readTree(file);
        JmxProcess jmx = (JmxProcess)mapper.treeToValue((TreeNode)jsonNode, JmxProcess.class);
        jmx.setName(file.getName());
        return jmx;
    }
}

