/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.cli.ExistingDirectoryValidator;
import com.googlecode.jmxtrans.cli.ExistingFileValidator;
import com.googlecode.jmxtrans.cli.ExistingFilenameValidator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;

public class JmxTransConfiguration {
    @Parameter(names={"-c", "--continue-on-error"}, description="If it is false, then JmxTrans will stop when one of the JSON configuration file is invalid. Otherwise, it will just print an error and continue processing.", arity=1)
    private boolean continueOnJsonError = false;
    @Parameter(names={"-j", "--json-directory"}, validateValueWith={ExistingDirectoryValidator.class})
    private File processConfigDir;
    @Parameter(names={"-f", "--json-file"}, validateValueWith={ExistingFileValidator.class})
    private File processConfigFile;
    @Parameter(names={"--config"}, description="global jmxtrans configuration file", validateValueWith={ExistingFileValidator.class})
    private File configFile;
    @Parameter(names={"-e", "--run-endlessly"}, description="If this is set, then this class will execute the main() loop and then wait 60 seconds until running again.")
    private boolean runEndlessly = false;
    @Parameter(names={"-q", "--quartz-properties-file"}, description="The Quartz server properties.", validateValueWith={ExistingFileValidator.class})
    private File quartzPropertiesFile = null;
    @Parameter(names={"-s", "--run-period-in-seconds"}, description="The seconds between server job runs.", validateWith={PositiveInteger.class})
    private int runPeriod = 60;
    @Parameter(names={"-h", "--help"}, help=true)
    private boolean help = false;
    @Parameter(names={"-a", "--additional-jars"}, validateWith={ExistingFilenameValidator.class}, variableArity=true)
    private List<String> additionalJars = ImmutableList.of();
    @Parameter(names={"--query-processor-executor-pool-size"}, description="Number of threads used to process queries.", validateWith={PositiveInteger.class})
    private int queryProcessorExecutorPoolSize = 10;
    @Parameter(names={"--query-processor-executor-work-queue-capacity"}, description="Size of the query work queue", validateWith={PositiveInteger.class})
    private int queryProcessorExecutorWorkQueueCapacity = 100000;
    @Parameter(names={"--result-processor-executor-pool-size"}, description="Number of threads used to process results", validateWith={PositiveInteger.class})
    private int resultProcessorExecutorPoolSize = 10;
    @Parameter(names={"--result-processor-executor-work-queue-capacity"}, description="Size of the result work queue", validateWith={PositiveInteger.class})
    private int resultProcessorExecutorWorkQueueCapacity = 100000;

    public File getProcessConfigDirOrFile() {
        if (this.processConfigDir != null) {
            return this.processConfigDir;
        }
        return this.processConfigFile;
    }

    public Iterable<File> getAdditionalJars() {
        return FluentIterable.from(this.additionalJars).transform((Function)new Function<String, File>(){

            @Nullable
            public File apply(String input) {
                return new File(input);
            }
        }).toList();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isContinueOnJsonError() {
        return this.continueOnJsonError;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setContinueOnJsonError(boolean continueOnJsonError) {
        this.continueOnJsonError = continueOnJsonError;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setProcessConfigDir(File processConfigDir) {
        this.processConfigDir = processConfigDir;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setProcessConfigFile(File processConfigFile) {
        this.processConfigFile = processConfigFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public File getConfigFile() {
        return this.configFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isRunEndlessly() {
        return this.runEndlessly;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setRunEndlessly(boolean runEndlessly) {
        this.runEndlessly = runEndlessly;
    }

    @SuppressFBWarnings(justification="generated code")
    public File getQuartzPropertiesFile() {
        return this.quartzPropertiesFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQuartzPropertiesFile(File quartzPropertiesFile) {
        this.quartzPropertiesFile = quartzPropertiesFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getRunPeriod() {
        return this.runPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setRunPeriod(int runPeriod) {
        this.runPeriod = runPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isHelp() {
        return this.help;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setHelp(boolean help) {
        this.help = help;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setAdditionalJars(List<String> additionalJars) {
        this.additionalJars = additionalJars;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getQueryProcessorExecutorPoolSize() {
        return this.queryProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQueryProcessorExecutorPoolSize(int queryProcessorExecutorPoolSize) {
        this.queryProcessorExecutorPoolSize = queryProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getQueryProcessorExecutorWorkQueueCapacity() {
        return this.queryProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQueryProcessorExecutorWorkQueueCapacity(int queryProcessorExecutorWorkQueueCapacity) {
        this.queryProcessorExecutorWorkQueueCapacity = queryProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getResultProcessorExecutorPoolSize() {
        return this.resultProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setResultProcessorExecutorPoolSize(int resultProcessorExecutorPoolSize) {
        this.resultProcessorExecutorPoolSize = resultProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getResultProcessorExecutorWorkQueueCapacity() {
        return this.resultProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setResultProcessorExecutorWorkQueueCapacity(int resultProcessorExecutorWorkQueueCapacity) {
        this.resultProcessorExecutorWorkQueueCapacity = resultProcessorExecutorWorkQueueCapacity;
    }
}

