/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class JmxResultProcessor {
    private final Query query;
    private final ObjectInstance objectInstance;
    private final String className;
    private final String objDomain;
    private final List<Attribute> attributes;

    public JmxResultProcessor(Query query, ObjectInstance objectInstance, List<Attribute> attributes, String className, String objDomain) {
        this.query = query;
        this.objectInstance = objectInstance;
        this.className = className;
        this.objDomain = objDomain;
        this.attributes = attributes;
    }

    public ImmutableList<Result> getResults() {
        ResultsBuilder builder = new ResultsBuilder();
        for (Attribute attribute : this.attributes) {
            builder.add(attribute.getName(), attribute.getValue());
        }
        return builder.build();
    }

    private class ResultsBuilder {
        private final ImmutableList.Builder<Result> accumulator = ImmutableList.builder();
        private final long epoch = System.currentTimeMillis();

        private ResultsBuilder() {
        }

        private void add(String name, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof CompositeData) {
                this.add(name, (CompositeData)value);
            } else if (value instanceof CompositeData[]) {
                for (CompositeData cd : (CompositeData[])value) {
                    this.add(name, cd);
                }
            } else if (value instanceof ObjectName[]) {
                this.add(name, (ObjectName[])value);
            } else if (value.getClass().isArray()) {
                HashMap values = Maps.newHashMap();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object val = Array.get(value, i);
                    values.put(name + "." + i, val);
                }
                this.addNew(name, values);
            } else if (value instanceof TabularData) {
                this.add(name, (TabularData)value);
            } else if (value instanceof Map) {
                this.add(name, (Map)value);
            } else {
                this.addNew(name, Collections.singletonMap(name, value));
            }
        }

        private void add(String attributeName, Map<Object, Object> map) {
            ImmutableMap.Builder values = ImmutableMap.builder();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                values.put((Object)entry.getKey().toString(), entry.getValue());
            }
            this.addNew(attributeName, (Map<String, Object>)values.build());
        }

        private void add(String attributeName, ObjectName[] objs) {
            ImmutableMap.Builder values = ImmutableMap.builder();
            for (ObjectName obj : objs) {
                values.put((Object)obj.getCanonicalName(), (Object)obj.getKeyPropertyListString());
            }
            this.addNew(attributeName, (Map<String, Object>)values.build());
        }

        private void add(String attributeName, CompositeData cds) {
            CompositeType t = cds.getCompositeType();
            HashMap values = Maps.newHashMap();
            Set<String> keys = t.keySet();
            for (String key : keys) {
                Object value = cds.get(key);
                if (value instanceof TabularData) {
                    TabularData tds = (TabularData)value;
                    this.add(attributeName + "." + key, tds);
                    continue;
                }
                if (value instanceof CompositeData) {
                    CompositeData cds2 = (CompositeData)value;
                    this.add(attributeName, cds2);
                    return;
                }
                if (value == null) continue;
                values.put(key, value);
            }
            this.addNew(attributeName, values);
        }

        private void add(String attributeName, TabularData tds) {
            Set<?> keys = tds.keySet();
            for (List key : keys) {
                CompositeData compositeData = tds.get(key.toArray());
                String attributeName2 = Joiner.on((char)'.').join((Iterable)key);
                this.add(attributeName + "." + attributeName2, compositeData);
            }
        }

        private void addNew(String attributeName, Map<String, Object> values) {
            this.accumulator.add((Object)new Result(this.epoch, attributeName, JmxResultProcessor.this.className, JmxResultProcessor.this.objDomain, JmxResultProcessor.this.query.getResultAlias(), JmxResultProcessor.this.objectInstance.getObjectName().getKeyPropertyListString(), values));
        }

        public ImmutableList<Result> build() {
            return this.accumulator.build();
        }
    }
}

