/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@ThreadSafe
@Immutable
public class Result {
    private final String attributeName;
    private final String className;
    private final String objDomain;
    private final String typeName;
    @Nonnull
    private final ImmutableMap<String, Object> values;
    private final long epoch;
    private final String keyAlias;

    public Result(long epoch, String attributeName, String className, String objDomain, String keyAlias, String typeName, @Nonnull Map<String, Object> values) {
        this.className = className;
        this.objDomain = objDomain;
        this.typeName = typeName;
        this.values = ImmutableMap.copyOf(values);
        this.epoch = epoch;
        this.attributeName = attributeName;
        this.keyAlias = keyAlias;
    }

    public Map<String, String> getTypeNameMap() {
        return TypeNameValue.extractMap(this.typeName);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$objDomain = this.getObjDomain();
        String other$objDomain = other.getObjDomain();
        if (this$objDomain == null ? other$objDomain != null : !this$objDomain.equals(other$objDomain)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ImmutableMap<String, Object> this$values = this.getValues();
        ImmutableMap<String, Object> other$values = other.getValues();
        if (this$values == null ? other$values != null : !this$values.equals(other$values)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        String this$keyAlias = this.getKeyAlias();
        String other$keyAlias = other.getKeyAlias();
        return !(this$keyAlias == null ? other$keyAlias != null : !this$keyAlias.equals(other$keyAlias));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $objDomain = this.getObjDomain();
        result = result * 59 + ($objDomain == null ? 43 : $objDomain.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ImmutableMap<String, Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : $values.hashCode());
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        String $keyAlias = this.getKeyAlias();
        result = result * 59 + ($keyAlias == null ? 43 : $keyAlias.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Result(attributeName=" + this.getAttributeName() + ", className=" + this.getClassName() + ", objDomain=" + this.getObjDomain() + ", typeName=" + this.getTypeName() + ", values=" + this.getValues() + ", epoch=" + this.getEpoch() + ", keyAlias=" + this.getKeyAlias() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public String getAttributeName() {
        return this.attributeName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getClassName() {
        return this.className;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getObjDomain() {
        return this.objDomain;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getTypeName() {
        return this.typeName;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<String, Object> getValues() {
        return this.values;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKeyAlias() {
        return this.keyAlias;
    }
}

