/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Result;
import java.util.Map;

public final class ResultFixtures {
    private ResultFixtures() {
    }

    public static Result booleanTrueResult() {
        return new Result(0L, "Verbose", "sun.management.MemoryImpl", "ObjectDomainName", "VerboseMemory", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"Verbose", (Object)true));
    }

    public static ImmutableList<Result> singleTrueResult() {
        return ImmutableList.of((Object)ResultFixtures.booleanTrueResult());
    }

    public static Result booleanFalseResult() {
        return new Result(0L, "Verbose", "sun.management.MemoryImpl", "ObjectDomainName", "VerboseMemory", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"Verbose", (Object)false));
    }

    public static Result numericResult() {
        return ResultFixtures.numericResult(10);
    }

    public static Result numericResult(Object numericValue) {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"ObjectPendingFinalizationCount", (Object)numericValue));
    }

    public static Result numericResultWithColon() {
        return ResultFixtures.numericResultWithColon(10);
    }

    public static Result numericResultWithColon(Object numericValue) {
        return new Result(0L, "Count", "com.yammer.metrics.reporting.JmxReporter$Meter", "fakehostname.example.com-org.openrepose.core", null, "type=\"ResponseCode\",scope=\"127.0.0.1:8008\",name=\"4XX\"", (Map<String, Object>)ImmutableMap.of((Object)"Count", (Object)numericValue));
    }

    public static Result stringResult() {
        return ResultFixtures.stringResult("value is a string");
    }

    public static Result stringResult(String value) {
        return new Result(0L, "NonHeapMemoryUsage", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"ObjectPendingFinalizationCount", (Object)value));
    }

    public static Result hashResult() {
        return new Result(0L, "NonHeapMemoryUsage", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"committed", (Object)12345, (Object)"init", (Object)23456, (Object)"max", (Object)-1, (Object)"used", (Object)45678));
    }

    public static Result numericBelowCPrecisionResult() {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (Map<String, Object>)ImmutableMap.of((Object)"ObjectPendingFinalizationCount", (Object)Double.MIN_VALUE));
    }

    public static Iterable<Result> singleNumericBelowCPrecisionResult() {
        return ImmutableList.of((Object)ResultFixtures.numericBelowCPrecisionResult());
    }

    public static Result numericResultWithTypenames(String typeName) {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "ObjectPendingFinalizationCount", typeName, (Map<String, Object>)ImmutableMap.of((Object)"ObjectPendingFinalizationCount", (Object)10));
    }

    public static ImmutableList<Result> singleFalseResult() {
        return ImmutableList.of((Object)ResultFixtures.booleanFalseResult());
    }

    public static ImmutableList<Result> singleNumericResult() {
        return ImmutableList.of((Object)ResultFixtures.numericResult());
    }

    public static ImmutableList<Result> dummyResults() {
        return ImmutableList.of((Object)ResultFixtures.numericResult(), (Object)ResultFixtures.booleanTrueResult(), (Object)ResultFixtures.booleanFalseResult());
    }

    public static ImmutableList<Result> dummyResultWithColon() {
        return ImmutableList.of((Object)ResultFixtures.numericResultWithColon(), (Object)ResultFixtures.booleanTrueResult());
    }

    public static ImmutableList<Result> singleResult(Result result) {
        return ImmutableList.of((Object)result);
    }
}

