/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.executors;

import com.googlecode.jmxtrans.executors.ExecutorFactory;
import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.monitoring.ManagedThreadPoolExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.management.MalformedObjectNameException;

public class SeparateExecutorRepository
implements ExecutorRepository {
    @Nonnull
    private final ConcurrentHashMap<Server, ThreadPoolExecutor> repository;
    @Nonnull
    private final ExecutorFactory executorFactory;
    @Nonnull
    private final List<ManagedThreadPoolExecutor> mBeans;

    public SeparateExecutorRepository(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
        this.repository = new ConcurrentHashMap();
        this.mBeans = new CopyOnWriteArrayList<ManagedThreadPoolExecutor>();
    }

    @Override
    public Collection<ThreadPoolExecutor> getExecutors() {
        return this.repository.values();
    }

    @Override
    public ThreadPoolExecutor getExecutor(Server server) {
        return this.repository.get(server);
    }

    @Override
    public Collection<ManagedThreadPoolExecutor> getMBeans() {
        return Collections.unmodifiableList(this.mBeans);
    }

    @Override
    public void put(Server server) throws MalformedObjectNameException {
        ManagedThreadPoolExecutor managedThreadPoolExecutor = this.executorFactory.create(server.getId());
        this.repository.put(server, managedThreadPoolExecutor.getExecutor());
        this.mBeans.add(managedThreadPoolExecutor);
    }
}

