/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jobs;

import com.googlecode.jmxtrans.jmx.JmxUtils;
import com.googlecode.jmxtrans.model.Server;
import javax.inject.Inject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);
    private final JmxUtils jmxUtils;

    @Inject
    public ServerJob(JmxUtils jmxUtils) {
        this.jmxUtils = jmxUtils;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap map = context.getMergedJobDataMap();
        Server server = (Server)map.get((Object)Server.class.getName());
        log.debug("+++++ Started server job: {}", (Object)server);
        try {
            this.jmxUtils.processServer(server);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
        log.debug("+++++ Finished server job: {}", (Object)server);
    }
}

