/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class JmxResultProcessor {
    private final Query query;
    private final ObjectInstance objectInstance;
    private final String className;
    private final String objDomain;
    private final List<Attribute> attributes;

    public JmxResultProcessor(Query query, ObjectInstance objectInstance, List<Attribute> attributes, String className, String objDomain) {
        this.query = query;
        this.objectInstance = objectInstance;
        this.className = className;
        this.objDomain = objDomain;
        this.attributes = attributes;
    }

    public ImmutableList<Result> getResults() {
        ResultsBuilder builder = new ResultsBuilder();
        for (Attribute attribute : this.attributes) {
            builder.add(attribute.getName(), attribute.getValue());
        }
        return builder.build();
    }

    private class ResultsBuilder {
        private final ImmutableList.Builder<Result> accumulator = ImmutableList.builder();
        private final long epoch = System.currentTimeMillis();

        private ResultsBuilder() {
        }

        private void add(String attributeName, Object value) {
            this.add(attributeName, (ImmutableList.Builder<String>)ImmutableList.builder(), value);
        }

        private ImmutableList.Builder<String> newValuePath(ImmutableList.Builder<String> valuePath, String name) {
            return ImmutableList.builder().addAll((Iterable)valuePath.build()).add((Object)name);
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof CompositeData) {
                this.add(attributeName, valuePath, (CompositeData)value);
            } else if (value instanceof CompositeData[]) {
                for (CompositeData cd : (CompositeData[])value) {
                    this.add(attributeName, cd);
                }
            } else if (value instanceof ObjectName[]) {
                this.add(attributeName, valuePath, (ObjectName[])value);
            } else if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object val = Array.get(value, i);
                    this.add(attributeName, this.newValuePath(valuePath, Integer.toString(i)), val);
                }
            } else if (value instanceof TabularData) {
                this.add(attributeName, valuePath, (TabularData)value);
            } else if (value instanceof Map) {
                this.add(attributeName, valuePath, (Map)value);
            } else if (value instanceof Iterable) {
                this.add(attributeName, valuePath, (Iterable)value);
            } else {
                this.addNew(attributeName, valuePath, value);
            }
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                this.add(attributeName, this.newValuePath(valuePath, entry.getKey().toString()), entry.getValue());
            }
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, ObjectName[] objs) {
            ImmutableMap.Builder values = ImmutableMap.builder();
            for (ObjectName obj : objs) {
                values.put((Object)obj.getCanonicalName(), (Object)obj.getKeyPropertyListString());
            }
            this.addNew(attributeName, valuePath, values.build());
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, CompositeData cds) {
            CompositeType t = cds.getCompositeType();
            Set<String> keys = t.keySet();
            for (String key : keys) {
                Object value = cds.get(key);
                this.add(attributeName, this.newValuePath(valuePath, key), value);
            }
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, Iterable iterable) {
            int index = 0;
            for (Object value : iterable) {
                this.add(attributeName, this.newValuePath(valuePath, Integer.toString(index++)), value);
            }
        }

        private void add(String attributeName, ImmutableList.Builder<String> valuePath, TabularData tds) {
            Set<?> keys = tds.keySet();
            for (List key : keys) {
                CompositeData compositeData = tds.get(key.toArray());
                String attributeName2 = Joiner.on((char)'.').join((Iterable)key);
                this.add(attributeName, this.newValuePath(valuePath, attributeName2), compositeData);
            }
        }

        private void addNew(String attributeName, ImmutableList.Builder<String> valuePath, Object value) {
            this.accumulator.add((Object)new Result(this.epoch, attributeName, JmxResultProcessor.this.className, JmxResultProcessor.this.objDomain, JmxResultProcessor.this.query.getResultAlias(), JmxResultProcessor.this.objectInstance.getObjectName().getKeyPropertyListString(), (ImmutableList<String>)valuePath.build(), value));
        }

        public ImmutableList<Result> build() {
            return this.accumulator.build();
        }
    }
}

