/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Result;

public final class ResultFixtures {
    private ResultFixtures() {
    }

    public static Result booleanTrueResult() {
        return new Result(0L, "Verbose", "sun.management.MemoryImpl", "ObjectDomainName", "VerboseMemory", "type=Memory", (ImmutableList<String>)ImmutableList.of(), true);
    }

    public static ImmutableList<Result> singleTrueResult() {
        return ImmutableList.of((Object)ResultFixtures.booleanTrueResult());
    }

    public static Result booleanFalseResult() {
        return new Result(0L, "Verbose", "sun.management.MemoryImpl", "ObjectDomainName", "VerboseMemory", "type=Memory", (ImmutableList<String>)ImmutableList.of(), false);
    }

    public static Result numericResult() {
        return ResultFixtures.numericResult(10);
    }

    public static Result numericResult(Object numericValue) {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (ImmutableList<String>)ImmutableList.of(), numericValue);
    }

    public static Result numericResultWithColon() {
        return ResultFixtures.numericResultWithColon(10);
    }

    public static Result numericResultWithColon(Object numericValue) {
        return new Result(0L, "Count", "com.yammer.metrics.reporting.JmxReporter$Meter", "fakehostname.example.com-org.openrepose.core", null, "type=\"ResponseCode\",scope=\"127.0.0.1:8008\",name=\"4XX\"", (ImmutableList<String>)ImmutableList.of(), numericValue);
    }

    public static Result stringResult() {
        return ResultFixtures.stringResult("value is a string");
    }

    public static Result stringResult(String value) {
        return new Result(0L, "NonHeapMemoryUsage", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (ImmutableList<String>)ImmutableList.of((Object)"ObjectPendingFinalizationCount"), value);
    }

    private static Result nonHeapMemoryResult(String valuePath, int value) {
        return new Result(0L, "NonHeapMemoryUsage", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (ImmutableList<String>)ImmutableList.of((Object)valuePath), value);
    }

    public static ImmutableList<Result> hashResults() {
        return ImmutableList.of((Object)ResultFixtures.nonHeapMemoryResult("committed", 12345), (Object)ResultFixtures.nonHeapMemoryResult("init", 23456), (Object)ResultFixtures.nonHeapMemoryResult("max", -1), (Object)ResultFixtures.nonHeapMemoryResult("used", 45678));
    }

    public static Result numericBelowCPrecisionResult() {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "MemoryAlias", "type=Memory", (ImmutableList<String>)ImmutableList.of(), Double.MIN_VALUE);
    }

    public static Iterable<Result> singleNumericBelowCPrecisionResult() {
        return ImmutableList.of((Object)ResultFixtures.numericBelowCPrecisionResult());
    }

    public static Result numericResultWithTypenames(String typeName) {
        return new Result(0L, "ObjectPendingFinalizationCount", "sun.management.MemoryImpl", "ObjectDomainName", "ObjectPendingFinalizationCount", typeName, (ImmutableList<String>)ImmutableList.of(), 10);
    }

    public static ImmutableList<Result> singleFalseResult() {
        return ImmutableList.of((Object)ResultFixtures.booleanFalseResult());
    }

    public static ImmutableList<Result> singleNumericResult() {
        return ImmutableList.of((Object)ResultFixtures.numericResult());
    }

    public static ImmutableList<Result> dummyResults() {
        return ImmutableList.of((Object)ResultFixtures.numericResult(), (Object)ResultFixtures.booleanTrueResult(), (Object)ResultFixtures.booleanFalseResult());
    }

    public static ImmutableList<Result> dummyResultWithColon() {
        return ImmutableList.of((Object)ResultFixtures.numericResultWithColon(), (Object)ResultFixtures.booleanTrueResult());
    }

    public static ImmutableList<Result> singleResult(Result result) {
        return ImmutableList.of((Object)result);
    }
}

