/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public final class ResultAttributes {
    public static final ResultAttribute TYPE_NAME = new ResultAttribute("typeName"){

        @Override
        public String get(Result result) {
            return result.getTypeName();
        }
    };
    public static final ResultAttribute OBJ_DOMAIN = new ResultAttribute("objDomain"){

        @Override
        public String get(Result result) {
            return result.getObjDomain();
        }
    };
    public static final ResultAttribute CLASS_NAME = new ResultAttribute("className"){

        @Override
        public String get(Result result) {
            return result.getClassName();
        }
    };
    public static final ResultAttribute ATTRIBUTE_NAME = new ResultAttribute("attributeName"){

        @Override
        public String get(Result result) {
            return result.getAttributeName();
        }
    };

    private ResultAttributes() {
    }

    public static ResultAttribute forName(@Nonnull String attributeName) {
        if (attributeName.startsWith("typeName.")) {
            return new TypeNameProperty(attributeName.substring("typeName.".length()));
        }
        String[] split = StringUtils.splitByCharacterTypeCamelCase((String)attributeName);
        StringBuilder sb = new StringBuilder(split[0].toUpperCase()).append("_").append(split[1].toUpperCase());
        return ResultAttributes.valueOf(sb.toString());
    }

    public static ImmutableSet<ResultAttribute> forNames(@Nonnull Collection<String> attributeNames) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String attributeName : attributeNames) {
            builder.add((Object)ResultAttributes.forName(attributeName));
        }
        return builder.build();
    }

    public static ResultAttribute valueOf(@Nonnull String attributeName) {
        ResultAttribute value;
        switch (attributeName) {
            case "TYPE_NAME": {
                value = TYPE_NAME;
                break;
            }
            case "OBJ_DOMAIN": {
                value = OBJ_DOMAIN;
                break;
            }
            case "CLASS_NAME": {
                value = CLASS_NAME;
                break;
            }
            case "ATTRIBUTE_NAME": {
                value = ATTRIBUTE_NAME;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value " + attributeName);
            }
        }
        return value;
    }

    public static List<ResultAttribute> values() {
        return Arrays.asList(TYPE_NAME, OBJ_DOMAIN, CLASS_NAME, ATTRIBUTE_NAME);
    }

    private static final class TypeNameProperty
    extends ResultAttribute {
        private static final String PREFIX = "typeName.";
        private final String propertyName;

        private TypeNameProperty(String propertyName) {
            super(PREFIX + propertyName);
            this.propertyName = propertyName;
        }

        @Override
        public String get(Result result) {
            return result.getTypeNameMap().get(this.propertyName);
        }
    }
}

