/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.ResultSerializer;
import java.util.List;

public class KeyValueResultSerializer
implements ResultSerializer {
    private static final String DEFAULT_FORMAT = "%s=%s";
    private final String format;
    private final List<String> typeNames;

    public KeyValueResultSerializer(@JsonProperty(value="format") String format, @JsonProperty List<String> typeNames) {
        this.format = (String)MoreObjects.firstNonNull((Object)format, (Object)DEFAULT_FORMAT);
        this.typeNames = typeNames;
    }

    public static KeyValueResultSerializer createDefault(List<String> typeNames) {
        return new KeyValueResultSerializer(DEFAULT_FORMAT, typeNames);
    }

    @Override
    public String serialize(Server server, Query query, Result result) {
        return String.format(this.format, KeyUtils.getKeyString(query, result, this.typeNames), result.getValue());
    }
}

