/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.ResultSerializer;
import com.googlecode.jmxtrans.model.output.ToStringResultSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;

public class StdOutWriter
implements OutputWriterFactory {
    private final ImmutableList<String> typeNames;
    private final boolean booleanAsNumber;
    private final Boolean debugEnabled;
    private final ResultSerializer resultSerializer;
    private final Map<String, Object> settings;

    @JsonCreator
    public StdOutWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="resultSerializer") ResultSerializer resultSerializer, @JsonProperty(value="settings") Map<String, Object> settings) {
        this.typeNames = typeNames;
        this.booleanAsNumber = booleanAsNumber;
        this.debugEnabled = debugEnabled;
        this.settings = settings;
        this.resultSerializer = (ResultSerializer)MoreObjects.firstNonNull((Object)resultSerializer, (Object)ToStringResultSerializer.DEFAULT);
    }

    public OutputWriter create() {
        return new W(this.typeNames, this.booleanAsNumber, this.debugEnabled, this.settings, this.resultSerializer);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StdOutWriter(typeNames=" + this.typeNames + ", booleanAsNumber=" + this.booleanAsNumber + ", debugEnabled=" + this.debugEnabled + ", resultSerializer=" + this.resultSerializer + ", settings=" + this.settings + ")";
    }

    public static class W
    extends BaseOutputWriter {
        private final ResultSerializer resultSerializer;

        public W(ImmutableList<String> typeNames, boolean booleanAsNumber, Boolean debugEnabled, Map<String, Object> settings, ResultSerializer resultSerializer) {
            super(typeNames, booleanAsNumber, debugEnabled, settings);
            this.resultSerializer = resultSerializer;
        }

        @Override
        public void validateSetup(Server server, Query query) throws ValidationException {
        }

        @Override
        protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
            for (Result r : results) {
                String s = this.resultSerializer.serialize(server, query, r);
                if (s == null) continue;
                System.out.println(s);
            }
        }
    }
}

