/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.googlecode.jmxtrans.cli.CliArgumentParser;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.cli.OptionsException;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommonsCliArgumentParser
implements CliArgumentParser {
    @Override
    @Nonnull
    public JmxTransConfiguration parseOptions(@Nonnull String[] args) throws OptionsException, ParseException {
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(this.getOptions(), args);
        Option[] options = cl.getOptions();
        JmxTransConfiguration configuration = new JmxTransConfiguration();
        for (Option option : options) {
            if (option.getOpt().equals("c")) {
                configuration.setContinueOnJsonError(Boolean.parseBoolean(option.getValue()));
                continue;
            }
            if (option.getOpt().equals("j")) {
                File jsonDir = new File(option.getValue());
                if (jsonDir.exists() && jsonDir.isDirectory()) {
                    configuration.setProcessConfigDir(jsonDir);
                    continue;
                }
                throw new OptionsException("Path to json directory is invalid: " + jsonDir);
            }
            if (option.getOpt().equals("f")) {
                File jsonFile = new File(option.getValue());
                if (jsonFile.exists() && jsonFile.isFile()) {
                    configuration.setProcessConfigFile(jsonFile);
                    continue;
                }
                throw new OptionsException("Path to json file is invalid: " + jsonFile);
            }
            if (option.getOpt().equals("e")) {
                configuration.setRunEndlessly(true);
                continue;
            }
            if (option.getOpt().equals("s")) {
                try {
                    configuration.setRunPeriod(Integer.parseInt(option.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new OptionsException("Seconds between server job runs must be an integer");
                }
            }
            if (option.getOpt().equals("a")) {
                configuration.setAdditionalJars(option.getValuesList());
                continue;
            }
            if (!option.getOpt().equals("h")) continue;
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar jmxtrans-all.jar", this.getOptions());
            configuration.setHelp(true);
        }
        if (!configuration.isHelp() && configuration.getProcessConfigDirOrFile() == null) {
            throw new OptionsException("Please specify either the -f or -j option.");
        }
        return configuration;
    }

    @Nonnull
    private Options getOptions() {
        Options options = new Options();
        options.addOption("c", true, "Continue processing even if one of the JSON configuration file is invalid.");
        options.addOption("j", true, "Directory where json configuration is stored. Default is .");
        options.addOption("f", true, "A single json file to execute.");
        options.addOption("e", false, "Run endlessly. Default false.");
        options.addOption("s", true, "Seconds between server job runs (not defined with cron). Default: 60");
        OptionBuilder.withArgName((String)"a");
        OptionBuilder.withLongOpt((String)"additionalJars");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Comma delimited list of additional jars to add to the class path");
        options.addOption(OptionBuilder.create((String)"a"));
        options.addOption("h", false, "Help");
        return options;
    }
}

