/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.cli.ExistingDirectoryValidator;
import com.googlecode.jmxtrans.cli.ExistingFileValidator;
import com.googlecode.jmxtrans.cli.ExistingFilenameValidator;
import com.googlecode.jmxtrans.cli.TypedProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;

public class JmxTransConfiguration {
    private static final String CONTINUE_ON_ERROR_PROPERTY = "continue.on.error";
    @Parameter(names={"-c", "--continue-on-error"}, description="If it is false, then JmxTrans will stop when one of the JSON configuration file is invalid. Otherwise, it will just print an error and continue processing.", arity=1)
    private boolean continueOnJsonError = false;
    private static final String JSON_DIRECTORY_PROPERTY = "json.directory";
    @Parameter(names={"-j", "--json-directory"}, validateValueWith={ExistingDirectoryValidator.class})
    private File processConfigDir;
    private static final String JSON_FILE_PROPERTY = "json.file";
    @Parameter(names={"-f", "--json-file"}, validateValueWith={ExistingFileValidator.class})
    private File processConfigFile;
    private static final String CONFIG_FILE_PROPERTY = "config.file";
    @Parameter(names={"--config"}, description="global jmxtrans configuration file", validateValueWith={ExistingFileValidator.class})
    private File configFile;
    private static final String RUN_ENDLESSLY_PROPERTY = "run.endlessly";
    @Parameter(names={"-e", "--run-endlessly"}, description="If this is set, then this class will execute the main() loop and then wait 60 seconds until running again.")
    private boolean runEndlessly = false;
    private static final String RUN_PERIOD_IN_SECONDS_PROPERTY = "run.period.in.seconds";
    @Parameter(names={"-s", "--run-period-in-seconds"}, description="The seconds between server job runs.", validateWith={PositiveInteger.class})
    private int runPeriod = 60;
    @Parameter(names={"-h", "--help"}, help=true)
    private boolean help = false;
    private static final String ADDITIONAL_JARS_PROPERTY = "additional.jars";
    @Parameter(names={"-a", "--additional-jars"}, validateWith={ExistingFilenameValidator.class}, variableArity=true)
    private List<String> additionalJars = ImmutableList.of();
    private static final String QUERY_PROCESSOR_EXECUTOR_POOL_SIZE_PROPERTY = "query.processor.executor.pool.size";
    @Parameter(names={"--query-processor-executor-pool-size"}, description="Number of threads used to process queries.", validateWith={PositiveInteger.class})
    private int queryProcessorExecutorPoolSize = 10;
    private static final String QUERY_PROCESSOR_EXECUTOR_WORK_QUEUE_CAPACITY_PROPERTY = "query.processor.executor.work.queue.capacity";
    @Parameter(names={"--query-processor-executor-work-queue-capacity"}, description="Size of the query work queue", validateWith={PositiveInteger.class})
    private int queryProcessorExecutorWorkQueueCapacity = 100000;
    private static final String RESULT_PROCESSOR_EXECUTOR_POOL_SIZE_PROPERTY = "result.processor.executor.pool.size";
    @Parameter(names={"--result-processor-executor-pool-size"}, description="Number of threads used to process results", validateWith={PositiveInteger.class})
    private int resultProcessorExecutorPoolSize = 10;
    private static final String RESULT_PROCESSOR_EXECUTOR_WORK_QUEUE_CAPACITY_PROPERTY = "result.processor.executor.work.queue.capacity";
    @Parameter(names={"--result-processor-executor-work-queue-capacity"}, description="Size of the result work queue", validateWith={PositiveInteger.class})
    private int resultProcessorExecutorWorkQueueCapacity = 100000;
    private static final String USE_SEPARATE_EXECUTORS_PROPERTY = "use.separate.executors";
    @Parameter(names={"--use-separate-executors"}, description="If this set every server node will be handed by separate executor.")
    private boolean useSeparateExecutors = false;
    private static final String SCHEDULED_EXECUTOR_POOL_SIZE_PROPERTY = "scheduled.executor.pool.size";
    @Parameter(names={"--scheduled-executor-pool-size"}, description="Number of threads used to run scheduler", validateWith={PositiveInteger.class})
    private int scheduledExecutorPoolSize = 2;
    private static PropertySetter[] SETTERS = new PropertySetter[]{new SinglePropertySetter<Boolean>("continue.on.error", Boolean.class){

        @Override
        protected void doSetValue(Boolean value, JmxTransConfiguration configuration) {
            configuration.setContinueOnJsonError(value);
        }
    }, new SinglePropertySetter<File>("json.directory", File.class){

        @Override
        protected void doSetValue(File value, JmxTransConfiguration configuration) {
            configuration.setProcessConfigDir(value);
        }
    }, new SinglePropertySetter<File>("json.file", File.class){

        @Override
        protected void doSetValue(File value, JmxTransConfiguration configuration) {
            configuration.setProcessConfigFile(value);
        }
    }, new SinglePropertySetter<File>("config.file", File.class){

        @Override
        protected void doSetValue(File value, JmxTransConfiguration configuration) {
            configuration.setConfigFile(value);
        }
    }, new SinglePropertySetter<Boolean>("run.endlessly", Boolean.class){

        @Override
        protected void doSetValue(Boolean value, JmxTransConfiguration configuration) {
            configuration.setRunEndlessly(value);
        }
    }, new SinglePropertySetter<Integer>("run.period.in.seconds", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setRunPeriod(value);
        }
    }, new MultiPropertySetter<String>("additional.jars", String.class){

        @Override
        protected void doSetValue(List<String> value, JmxTransConfiguration configuration) {
            configuration.setAdditionalJars(value);
        }
    }, new SinglePropertySetter<Integer>("query.processor.executor.pool.size", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setQueryProcessorExecutorPoolSize(value);
        }
    }, new SinglePropertySetter<Integer>("query.processor.executor.work.queue.capacity", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setQueryProcessorExecutorWorkQueueCapacity(value);
        }
    }, new SinglePropertySetter<Integer>("result.processor.executor.pool.size", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setResultProcessorExecutorPoolSize(value);
        }
    }, new SinglePropertySetter<Integer>("result.processor.executor.work.queue.capacity", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setResultProcessorExecutorWorkQueueCapacity(value);
        }
    }, new SinglePropertySetter<Boolean>("use.separate.executors", Boolean.class){

        @Override
        protected void doSetValue(Boolean value, JmxTransConfiguration configuration) {
            configuration.setUseSeparateExecutors(value);
        }
    }, new SinglePropertySetter<Integer>("scheduled.executor.pool.size", Integer.class){

        @Override
        protected void doSetValue(Integer value, JmxTransConfiguration configuration) {
            configuration.setScheduledExecutorPoolSize(value);
        }
    }};

    public File getProcessConfigDirOrFile() {
        if (this.processConfigDir != null) {
            return this.processConfigDir;
        }
        return this.processConfigFile;
    }

    public Iterable<File> getAdditionalJars() {
        return FluentIterable.from(this.additionalJars).transform((Function)new Function<String, File>(){

            @Nullable
            public File apply(String input) {
                return new File(input);
            }
        }).toList();
    }

    @VisibleForTesting
    void loadProperties(Properties properties) {
        TypedProperties typedProperties = new TypedProperties(properties);
        for (PropertySetter setter : SETTERS) {
            setter.setValue(typedProperties, this);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isContinueOnJsonError() {
        return this.continueOnJsonError;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setContinueOnJsonError(boolean continueOnJsonError) {
        this.continueOnJsonError = continueOnJsonError;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setProcessConfigDir(File processConfigDir) {
        this.processConfigDir = processConfigDir;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setProcessConfigFile(File processConfigFile) {
        this.processConfigFile = processConfigFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public File getConfigFile() {
        return this.configFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isRunEndlessly() {
        return this.runEndlessly;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setRunEndlessly(boolean runEndlessly) {
        this.runEndlessly = runEndlessly;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getRunPeriod() {
        return this.runPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setRunPeriod(int runPeriod) {
        this.runPeriod = runPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isHelp() {
        return this.help;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setHelp(boolean help) {
        this.help = help;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setAdditionalJars(List<String> additionalJars) {
        this.additionalJars = additionalJars;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getQueryProcessorExecutorPoolSize() {
        return this.queryProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQueryProcessorExecutorPoolSize(int queryProcessorExecutorPoolSize) {
        this.queryProcessorExecutorPoolSize = queryProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getQueryProcessorExecutorWorkQueueCapacity() {
        return this.queryProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setQueryProcessorExecutorWorkQueueCapacity(int queryProcessorExecutorWorkQueueCapacity) {
        this.queryProcessorExecutorWorkQueueCapacity = queryProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getResultProcessorExecutorPoolSize() {
        return this.resultProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setResultProcessorExecutorPoolSize(int resultProcessorExecutorPoolSize) {
        this.resultProcessorExecutorPoolSize = resultProcessorExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getResultProcessorExecutorWorkQueueCapacity() {
        return this.resultProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setResultProcessorExecutorWorkQueueCapacity(int resultProcessorExecutorWorkQueueCapacity) {
        this.resultProcessorExecutorWorkQueueCapacity = resultProcessorExecutorWorkQueueCapacity;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseSeparateExecutors() {
        return this.useSeparateExecutors;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setUseSeparateExecutors(boolean useSeparateExecutors) {
        this.useSeparateExecutors = useSeparateExecutors;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getScheduledExecutorPoolSize() {
        return this.scheduledExecutorPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setScheduledExecutorPoolSize(int scheduledExecutorPoolSize) {
        this.scheduledExecutorPoolSize = scheduledExecutorPoolSize;
    }

    private static abstract class MultiPropertySetter<T>
    extends PropertySetter<T> {
        MultiPropertySetter(String key, Class<T> type) {
            super(key, type);
        }

        @Override
        public void setValue(TypedProperties typedProperties, JmxTransConfiguration configuration) {
            List values = typedProperties.getTypedProperties(this.key, this.type);
            if (values != null && !values.isEmpty()) {
                this.doSetValue(values, configuration);
            }
        }

        protected abstract void doSetValue(List<T> var1, JmxTransConfiguration var2);
    }

    private static abstract class SinglePropertySetter<T>
    extends PropertySetter<T> {
        SinglePropertySetter(String key, Class<T> type) {
            super(key, type);
        }

        @Override
        public void setValue(TypedProperties typedProperties, JmxTransConfiguration configuration) {
            Object value = typedProperties.getTypedProperty(this.key, this.type);
            if (value != null) {
                this.doSetValue(value, configuration);
            }
        }

        protected abstract void doSetValue(T var1, JmxTransConfiguration var2);
    }

    private static abstract class PropertySetter<T> {
        protected final String key;
        protected final Class<T> type;

        protected PropertySetter(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public abstract void setValue(TypedProperties var1, JmxTransConfiguration var2);
    }
}

