/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;

class TypedProperties {
    @Nonnull
    private final Properties properties;
    private final IStringConverterFactory stringConverterFactory = new DefaultConverterFactory();

    TypedProperties(@Nonnull Properties properties) {
        this.properties = properties;
    }

    <T> T getTypedProperty(String key, Class<T> type) {
        String value = this.properties.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return this.convert(key, value, type);
    }

    <T> List<T> getTypedProperties(final String key, final Class<T> type) {
        String value = this.properties.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyList();
        }
        return Lists.transform(Arrays.asList(value.split("\\s*,\\s*")), (Function)new Function<String, T>(){

            public T apply(String input) {
                return TypedProperties.this.convert(key, input, type);
            }
        });
    }

    private <T> T convert(String key, String value, Class<T> type) {
        try {
            IStringConverter converter;
            Class converterClass = this.stringConverterFactory.getConverter(type);
            try {
                converter = (IStringConverter)converterClass.getConstructor(String.class).newInstance(key);
            }
            catch (NoSuchMethodException e) {
                converter = (IStringConverter)converterClass.newInstance();
            }
            return (T)converter.convert(value);
        }
        catch (ReflectiveOperationException e) {
            throw new ParameterException("Failed to convert " + key + " to " + type, (Throwable)e);
        }
    }
}

