/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.connections;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JMXConnection
implements Closeable {
    @Nullable
    private final JMXConnector connector;
    @Nonnull
    private final MBeanServerConnection mBeanServerConnection;
    private boolean markedAsDestroyed;
    private static final Logger logger = LoggerFactory.getLogger(JMXConnection.class);

    public JMXConnection(@Nullable JMXConnector connector, @Nonnull MBeanServerConnection mBeanServerConnection) {
        this.connector = connector;
        this.mBeanServerConnection = mBeanServerConnection;
        this.markedAsDestroyed = false;
    }

    public boolean isAlive() {
        return !this.markedAsDestroyed;
    }

    public void setMarkedAsDestroyed() {
        this.markedAsDestroyed = true;
    }

    @Override
    public void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                logger.error("Error occurred during close connection {}", (Object)this, (Object)e);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "JMXConnection(connector=" + this.connector + ", mBeanServerConnection=" + this.getMBeanServerConnection() + ", markedAsDestroyed=" + this.markedAsDestroyed + ")";
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public MBeanServerConnection getMBeanServerConnection() {
        return this.mBeanServerConnection;
    }
}

