/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.connections;

import com.googlecode.jmxtrans.connections.JMXConnection;
import com.googlecode.jmxtrans.connections.JmxConnectionProvider;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.management.remote.JMXConnector;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class MBeanServerConnectionFactory
extends BaseKeyedPoolableObjectFactory<JmxConnectionProvider, JMXConnection> {
    @Nonnull
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @Nonnull
    public JMXConnection makeObject(@Nonnull JmxConnectionProvider server) throws IOException {
        if (server.isLocal()) {
            return new JMXConnection(null, server.getLocalMBeanServer());
        }
        JMXConnector connection = server.getServerConnection();
        return new JMXConnection(connection, connection.getMBeanServerConnection());
    }

    public void destroyObject(@Nonnull JmxConnectionProvider key, final @Nonnull JMXConnection jmxConnection) throws IOException {
        if (!jmxConnection.isAlive()) {
            return;
        }
        jmxConnection.setMarkedAsDestroyed();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                jmxConnection.close();
            }
        });
    }

    public boolean validateObject(@Nonnull JmxConnectionProvider key, @Nonnull JMXConnection jmxConnection) {
        return jmxConnection.isAlive();
    }
}

