/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.executors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.jmxtrans.monitoring.ManagedThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;

public class ExecutorFactory {
    private final int defaultPoolSize;
    private final int defaultWorkQueueCapacity;
    private final String executorAlias;

    public ExecutorFactory(int defaultPoolSize, int defaultWorkQueueCapacity, String executorAlias) {
        this.defaultPoolSize = defaultPoolSize;
        this.defaultWorkQueueCapacity = defaultWorkQueueCapacity;
        this.executorAlias = executorAlias;
    }

    public ManagedThreadPoolExecutor create(String aliasSuffix) throws MalformedObjectNameException {
        String serverAlias = aliasSuffix == null ? this.executorAlias : String.format("%s-%s", this.executorAlias, aliasSuffix);
        ThreadFactory threadFactory = ExecutorFactory.threadFactory(serverAlias);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(this.defaultWorkQueueCapacity);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.defaultPoolSize, this.defaultPoolSize, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
        ManagedThreadPoolExecutor executorMBean = new ManagedThreadPoolExecutor(executor, serverAlias);
        return executorMBean;
    }

    public static ThreadFactory threadFactory(String alias) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jmxtrans-" + alias + "-%d").build();
    }
}

