/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.guice;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.module.guice.ObjectMapperModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.connections.MBeanServerConnectionFactory;
import com.googlecode.jmxtrans.executors.CommonExecutorRepository;
import com.googlecode.jmxtrans.executors.ExecutorFactory;
import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.executors.SeparateExecutorRepository;
import com.googlecode.jmxtrans.guice.JsonFormat;
import com.googlecode.jmxtrans.guice.YamlFormat;
import com.googlecode.jmxtrans.monitoring.ManagedGenericKeyedObjectPool;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.management.MalformedObjectNameException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransModule
extends AbstractModule {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JmxTransConfiguration configuration;

    public JmxTransModule(@Nonnull JmxTransConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bind(KeyedObjectPool.class).annotatedWith((Annotation)Names.named((String)"mbeanPool")).toInstance(this.getObjectPool((KeyedPoolableObjectFactory)new MBeanServerConnectionFactory(), MBeanServerConnectionFactory.class.getSimpleName(), 20000L));
    }

    @Provides
    JmxTransConfiguration jmxTransConfiguration() {
        return this.configuration;
    }

    @Provides
    @Singleton
    public ScheduledExecutorService scheduledExecutor() {
        return Executors.newScheduledThreadPool(this.configuration.getScheduledExecutorPoolSize(), ExecutorFactory.threadFactory("scheduler"));
    }

    @Provides
    @Singleton
    @Named(value="queryExecutorRepository")
    ExecutorRepository queryExecutorRepository() throws MalformedObjectNameException {
        int poolSize = this.configuration.getQueryProcessorExecutorPoolSize();
        int workQueueCapacity = this.configuration.getQueryProcessorExecutorWorkQueueCapacity();
        String executorAlias = "query";
        return this.createExecutorRepository(poolSize, workQueueCapacity, executorAlias);
    }

    @Provides
    @Singleton
    @Named(value="resultExecutorRepository")
    ExecutorRepository resultExecutorRepository() throws MalformedObjectNameException {
        int poolSize = this.configuration.getResultProcessorExecutorPoolSize();
        int workQueueCapacity = this.configuration.getResultProcessorExecutorWorkQueueCapacity();
        String executorAlias = "result";
        return this.createExecutorRepository(poolSize, workQueueCapacity, executorAlias);
    }

    private ExecutorRepository createExecutorRepository(int poolSize, int workQueueCapacity, String executorAlias) throws MalformedObjectNameException {
        ExecutorFactory executorFactory = new ExecutorFactory(poolSize, workQueueCapacity, executorAlias);
        boolean useSeparateExecutors = this.configuration.isUseSeparateExecutors();
        return useSeparateExecutors ? new SeparateExecutorRepository(executorFactory) : new CommonExecutorRepository(executorFactory);
    }

    private <K, V> GenericKeyedObjectPool<K, V> getObjectPool(KeyedPoolableObjectFactory<K, V> factory, String poolName, long maxWaitMillis) {
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setTestOnBorrow(true);
        pool.setMaxActive(-1);
        pool.setMaxIdle(-1);
        pool.setTimeBetweenEvictionRunsMillis(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        pool.setMinEvictableIdleTimeMillis(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        pool.setMaxWait(maxWaitMillis);
        pool.setTestOnReturn(true);
        pool.setTestOnBorrow(true);
        try {
            ManagedGenericKeyedObjectPool mbean = new ManagedGenericKeyedObjectPool(pool, poolName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, mbean.getObjectName());
        }
        catch (Exception e) {
            this.log.error("Could not register mbean for pool [{}]", (Object)poolName, (Object)e);
        }
        return pool;
    }

    @Nonnull
    public static Injector createInjector(@Nonnull JmxTransConfiguration configuration) {
        return Guice.createInjector((Module[])new Module[]{new JmxTransModule(configuration), new ObjectMapperModule(JsonFormat.class).registerModule((com.fasterxml.jackson.databind.Module)new GuavaModule()), new ObjectMapperModule(YamlFormat.class).withObjectMapper(new ObjectMapper((JsonFactory)new YAMLFactory())).registerModule((com.fasterxml.jackson.databind.Module)new GuavaModule())});
    }
}

