/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.name.Named;
import com.googlecode.jmxtrans.connections.JMXConnection;
import com.googlecode.jmxtrans.connections.JmxConnectionProvider;
import com.googlecode.jmxtrans.model.JmxTransRMIClientSocketFactory;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.sun.tools.attach.VirtualMachine;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.pool.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"alias", "local", "pid", "host", "port", "username", "password", "cronExpression", "numQueryThreads", "protocolProviderPackages"})
@Immutable
@ThreadSafe
public class Server
implements JmxConnectionProvider {
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String FRONT = "service:jmx:rmi:///jndi/rmi://";
    private static final String BACK = "/jmxrmi";
    private static final int DEFAULT_SOCKET_SO_TIMEOUT_MILLIS = 10000;
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final String id;
    private final String alias;
    private final String pid;
    private final String host;
    private final String port;
    private final String username;
    private final String password;
    private final String protocolProviderPackages;
    private final String url;
    @Deprecated
    @Nullable
    private final String cronExpression;
    @Nullable
    private final Integer runPeriodSeconds;
    private final int numQueryThreads;
    private final boolean local;
    private final boolean ssl;
    private final ImmutableSet<Query> queries;
    @Nonnull
    private final Iterable<OutputWriter> outputWriters;
    @Nonnull
    private final KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool;
    @Nonnull
    private final ImmutableList<OutputWriterFactory> outputWriterFactories;

    @JsonCreator
    public Server(@JsonProperty(value="alias") String alias, @JsonProperty(value="pid") String pid, @JsonProperty(value="host") String host, @JsonProperty(value="port") String port, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="protocolProviderPackages") String protocolProviderPackages, @JsonProperty(value="url") String url, @JsonProperty(value="cronExpression") String cronExpression, @JsonProperty(value="runPeriodSeconds") Integer runPeriodSeconds, @JsonProperty(value="numQueryThreads") Integer numQueryThreads, @JsonProperty(value="local") boolean local, @JsonProperty(value="ssl") boolean ssl, @JsonProperty(value="queries") List<Query> queries, @JsonProperty(value="outputWriters") List<OutputWriterFactory> outputWriters, @JacksonInject @Named(value="mbeanPool") KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool) {
        this(alias, pid, host, port, username, password, protocolProviderPackages, url, cronExpression, runPeriodSeconds, numQueryThreads, local, ssl, queries, outputWriters, (List<OutputWriter>)ImmutableList.of(), pool);
    }

    public Server(String alias, String pid, String host, String port, String username, String password, String protocolProviderPackages, String url, String cronExpression, Integer runPeriodSeconds, Integer numQueryThreads, boolean local, boolean ssl, List<Query> queries, ImmutableList<OutputWriter> outputWriters, KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool) {
        this(alias, pid, host, port, username, password, protocolProviderPackages, url, cronExpression, runPeriodSeconds, numQueryThreads, local, ssl, queries, (List<OutputWriterFactory>)ImmutableList.of(), (List<OutputWriter>)outputWriters, pool);
    }

    private Server(String alias, String pid, String host, String port, String username, String password, String protocolProviderPackages, String url, String cronExpression, Integer runPeriodSeconds, Integer numQueryThreads, boolean local, boolean ssl, List<Query> queries, List<OutputWriterFactory> outputWriterFactories, List<OutputWriter> outputWriters, KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool) {
        Preconditions.checkArgument((pid != null || url != null || host != null ? 1 : 0) != 0, (Object)"You must provide the pid or the [url|host and port]");
        Preconditions.checkArgument((pid == null || url == null && host == null ? 1 : 0) != 0, (Object)"You must provide the pid OR the url, not both");
        this.alias = alias;
        this.pid = pid;
        this.port = port;
        this.username = username;
        this.password = password;
        this.protocolProviderPackages = protocolProviderPackages;
        this.url = url;
        this.cronExpression = cronExpression;
        if (!Strings.isNullOrEmpty((String)cronExpression)) {
            logger.warn("cronExpression is deprecated, please use runPeriodSeconds instead.");
        }
        this.runPeriodSeconds = runPeriodSeconds;
        this.numQueryThreads = (Integer)MoreObjects.firstNonNull((Object)numQueryThreads, (Object)0);
        this.local = local;
        this.ssl = ssl;
        this.queries = ImmutableSet.copyOf(queries);
        if (pid != null) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.host = host;
        }
        this.pool = (KeyedObjectPool)Preconditions.checkNotNull(pool);
        this.outputWriterFactories = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(outputWriterFactories, (Object)ImmutableList.of())));
        this.outputWriters = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(outputWriters, (Object)ImmutableList.of())));
        this.id = String.format("%s_%s_%s", host, port, pid);
    }

    public Iterable<Result> execute(Query query) throws Exception {
        JMXConnection jmxConnection = null;
        try {
            jmxConnection = (JMXConnection)this.pool.borrowObject((Object)this);
            ImmutableList.Builder results = ImmutableList.builder();
            MBeanServerConnection connection = jmxConnection.getMBeanServerConnection();
            for (ObjectName queryName : query.queryNames(connection)) {
                results.addAll(query.fetchResults(connection, queryName));
            }
            ImmutableList immutableList = results.build();
            return immutableList;
        }
        catch (Exception e) {
            if (jmxConnection != null) {
                this.pool.invalidateObject((Object)this, (Object)jmxConnection);
                jmxConnection = null;
            }
            throw e;
        }
        finally {
            if (jmxConnection != null) {
                this.pool.returnObject((Object)this, (Object)jmxConnection);
            }
        }
    }

    @JsonIgnore
    public ImmutableMap<String, ?> getEnvironment() {
        if (this.getProtocolProviderPackages() != null && this.getProtocolProviderPackages().contains("weblogic")) {
            ImmutableMap.Builder environment = ImmutableMap.builder();
            if (this.username != null && this.password != null) {
                environment.put((Object)"jmx.remote.protocol.provider.pkgs", (Object)this.getProtocolProviderPackages());
                environment.put((Object)"java.naming.security.principal", (Object)this.username);
                environment.put((Object)"java.naming.security.credentials", (Object)this.password);
            }
            return environment.build();
        }
        ImmutableMap.Builder environment = ImmutableMap.builder();
        if (this.username != null && this.password != null) {
            String[] credentials = new String[]{this.username, this.password};
            environment.put((Object)"jmx.remote.credentials", (Object)credentials);
        }
        JmxTransRMIClientSocketFactory rmiClientSocketFactory = new JmxTransRMIClientSocketFactory(10000, this.ssl);
        environment.put((Object)"jmx.remote.rmi.client.socket.factory", (Object)rmiClientSocketFactory);
        environment.put((Object)"com.sun.jndi.rmi.factory.socket", (Object)rmiClientSocketFactory);
        return environment.build();
    }

    @Override
    @JsonIgnore
    public JMXConnector getServerConnection() throws IOException {
        JMXServiceURL url = this.getJmxServiceURL();
        return JMXConnectorFactory.connect(url, this.getEnvironment());
    }

    @Override
    @JsonIgnore
    public MBeanServer getLocalMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    @JsonIgnore
    public String getLabel() {
        return (String)MoreObjects.firstNonNull((Object)this.alias, (Object)this.host);
    }

    public String getHost() {
        if (this.host == null && this.url == null) {
            return null;
        }
        if (this.host != null) {
            return this.host;
        }
        return this.url.substring(this.url.lastIndexOf("//") + 2, this.url.lastIndexOf(58));
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSource() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getHost();
    }

    public String getPort() {
        if (this.port == null && this.url == null) {
            return null;
        }
        if (this.port != null) {
            return this.port;
        }
        return Server.extractPortFromUrl(this.url);
    }

    private static String extractPortFromUrl(String url) {
        String computedPort = url.substring(url.lastIndexOf(58) + 1);
        if (computedPort.contains("/")) {
            computedPort = computedPort.substring(0, computedPort.indexOf(47));
        }
        return computedPort;
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.host == null || this.port == null) {
                return null;
            }
            return FRONT + this.host + ":" + this.port + BACK;
        }
        return this.url;
    }

    @JsonIgnore
    public JMXServiceURL getJmxServiceURL() throws IOException {
        if (this.pid != null) {
            return JMXServiceURLFactory.extractJMXServiceURLFromPid(this.pid);
        }
        return new JMXServiceURL(this.getUrl());
    }

    @JsonIgnore
    public boolean isQueriesMultiThreaded() {
        return this.numQueryThreads > 0;
    }

    public void runOutputWriters(Query query, Iterable<Result> results) throws Exception {
        for (OutputWriter writer : this.outputWriters) {
            writer.doWrite(this, query, results);
        }
        logger.debug("Finished running outputWriters for query: {}", (Object)query);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Server server) {
        return new Builder(server);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$pid = this.getPid();
        String other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$protocolProviderPackages = this.getProtocolProviderPackages();
        String other$protocolProviderPackages = other.getProtocolProviderPackages();
        if (this$protocolProviderPackages == null ? other$protocolProviderPackages != null : !this$protocolProviderPackages.equals(other$protocolProviderPackages)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        Integer this$runPeriodSeconds = this.getRunPeriodSeconds();
        Integer other$runPeriodSeconds = other.getRunPeriodSeconds();
        if (this$runPeriodSeconds == null ? other$runPeriodSeconds != null : !((Object)this$runPeriodSeconds).equals(other$runPeriodSeconds)) {
            return false;
        }
        if (this.getNumQueryThreads() != other.getNumQueryThreads()) {
            return false;
        }
        if (this.isLocal() != other.isLocal()) {
            return false;
        }
        return this.isSsl() == other.isSsl();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : $pid.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $protocolProviderPackages = this.getProtocolProviderPackages();
        result = result * 59 + ($protocolProviderPackages == null ? 43 : $protocolProviderPackages.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        Integer $runPeriodSeconds = this.getRunPeriodSeconds();
        result = result * 59 + ($runPeriodSeconds == null ? 43 : ((Object)$runPeriodSeconds).hashCode());
        result = result * 59 + this.getNumQueryThreads();
        result = result * 59 + (this.isLocal() ? 79 : 97);
        result = result * 59 + (this.isSsl() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Server(pid=" + this.getPid() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", url=" + this.getUrl() + ", cronExpression=" + this.getCronExpression() + ", numQueryThreads=" + this.getNumQueryThreads() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPid() {
        return this.pid;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getUsername() {
        return this.username;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPassword() {
        return this.password;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getProtocolProviderPackages() {
        return this.protocolProviderPackages;
    }

    @Deprecated
    @Nullable
    @SuppressFBWarnings(justification="generated code")
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    public Integer getRunPeriodSeconds() {
        return this.runPeriodSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getNumQueryThreads() {
        return this.numQueryThreads;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isLocal() {
        return this.local;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isSsl() {
        return this.ssl;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<Query> getQueries() {
        return this.queries;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public Iterable<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<OutputWriterFactory> getOutputWriterFactories() {
        return this.outputWriterFactories;
    }

    @NotThreadSafe
    public static final class Builder {
        private String alias;
        private String pid;
        private String host;
        private String port;
        private String username;
        private String password;
        private String protocolProviderPackages;
        private String url;
        private String cronExpression;
        private Integer runPeriodSeconds;
        private Integer numQueryThreads;
        private boolean local;
        private boolean ssl;
        private final List<OutputWriterFactory> outputWriterFactories = new ArrayList<OutputWriterFactory>();
        private final List<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
        private final List<Query> queries = new ArrayList<Query>();
        private KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool;

        private Builder() {
        }

        private Builder(Server server) {
            this.alias = server.alias;
            this.pid = server.pid;
            this.host = server.pid != null ? null : server.host;
            this.port = server.port;
            this.username = server.username;
            this.password = server.password;
            this.protocolProviderPackages = server.protocolProviderPackages;
            this.url = server.url;
            this.cronExpression = server.cronExpression;
            this.runPeriodSeconds = server.runPeriodSeconds;
            this.numQueryThreads = server.numQueryThreads;
            this.local = server.local;
            this.ssl = server.ssl;
            this.queries.addAll((Collection<Query>)server.queries);
            this.pool = server.pool;
        }

        public Builder clearQueries() {
            this.queries.clear();
            return this;
        }

        public Builder addQuery(Query query) {
            this.queries.add(query);
            return this;
        }

        public Builder addQueries(Set<Query> queries) {
            this.queries.addAll(queries);
            return this;
        }

        public Builder addOutputWriterFactory(OutputWriterFactory outputWriterFactory) {
            this.outputWriterFactories.add(outputWriterFactory);
            return this;
        }

        public Builder addOutputWriters(Collection<OutputWriter> outputWriters) {
            this.outputWriters.addAll(outputWriters);
            return this;
        }

        public Server build() {
            if (!this.outputWriterFactories.isEmpty()) {
                return new Server(this.alias, this.pid, this.host, this.port, this.username, this.password, this.protocolProviderPackages, this.url, this.cronExpression, this.runPeriodSeconds, this.numQueryThreads, this.local, this.ssl, this.queries, this.outputWriterFactories, this.pool);
            }
            return new Server(this.alias, this.pid, this.host, this.port, this.username, this.password, this.protocolProviderPackages, this.url, this.cronExpression, this.runPeriodSeconds, this.numQueryThreads, this.local, this.ssl, this.queries, (ImmutableList<OutputWriter>)ImmutableList.copyOf(this.outputWriters), this.pool);
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPid(String pid) {
            this.pid = pid;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setProtocolProviderPackages(String protocolProviderPackages) {
            this.protocolProviderPackages = protocolProviderPackages;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setRunPeriodSeconds(Integer runPeriodSeconds) {
            this.runPeriodSeconds = runPeriodSeconds;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setNumQueryThreads(Integer numQueryThreads) {
            this.numQueryThreads = numQueryThreads;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setSsl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPool(KeyedObjectPool<JmxConnectionProvider, JMXConnection> pool) {
            this.pool = pool;
            return this;
        }
    }

    private static class JMXServiceURLFactory {
        private JMXServiceURLFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static JMXServiceURL extractJMXServiceURLFromPid(String pid) throws IOException {
            JMXServiceURL jMXServiceURL;
            VirtualMachine vm = VirtualMachine.attach(pid);
            try {
                String connectorAddress = vm.getAgentProperties().getProperty(Server.CONNECTOR_ADDRESS);
                if (connectorAddress == null) {
                    String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
                    vm.loadAgent(agent);
                    connectorAddress = vm.getAgentProperties().getProperty(Server.CONNECTOR_ADDRESS);
                }
                jMXServiceURL = new JMXServiceURL(connectorAddress);
            }
            catch (Throwable throwable) {
                try {
                    vm.detach();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            vm.detach();
            return jMXServiceURL;
        }
    }
}

