/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.scheduler;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.jmx.ResultProcessor;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.scheduler.ServerCommand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerScheduler {
    private static final Logger log = LoggerFactory.getLogger(ServerScheduler.class);
    private final JmxTransConfiguration configuration;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<ScheduledServerCommand> scheduledServerCommands = new ArrayList<ScheduledServerCommand>();
    private final ExecutorRepository queryExecutorRepository;
    private final ResultProcessor resultProcessor;

    @Inject
    public ServerScheduler(@Nonnull JmxTransConfiguration configuration, @Nonnull ScheduledExecutorService scheduledExecutor, @Nonnull @Named(value="queryExecutorRepository") ExecutorRepository queryExecutorRepository, @Nonnull ResultProcessor resultProcessor) {
        this.configuration = configuration;
        this.scheduledExecutor = scheduledExecutor;
        this.queryExecutorRepository = queryExecutorRepository;
        this.resultProcessor = resultProcessor;
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Server server) {
        ServerCommand serverCommand = new ServerCommand(server, this.queryExecutorRepository, this.resultProcessor);
        long runPeriod = serverCommand.getRunPeriodSeconds(this.configuration.getRunPeriod());
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(serverCommand, runPeriod, runPeriod, TimeUnit.SECONDS);
        List<ScheduledServerCommand> list = this.scheduledServerCommands;
        synchronized (list) {
            this.scheduledServerCommands.add(new ScheduledServerCommand(serverCommand, scheduledFuture));
        }
        log.debug("Scheduled job for server {}", (Object)serverCommand.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleAll() {
        List<ScheduledServerCommand> list = this.scheduledServerCommands;
        synchronized (list) {
            Iterator<ScheduledServerCommand> commandsIterator = this.scheduledServerCommands.iterator();
            while (commandsIterator.hasNext()) {
                ScheduledServerCommand command = commandsIterator.next();
                command.cancel();
                commandsIterator.remove();
                log.debug("Deleted scheduled job for server {}", (Object)command.getName());
            }
        }
    }

    public void stop() {
        if (!this.scheduledExecutor.isShutdown()) {
            this.scheduledExecutor.shutdown();
            log.debug("Shutdown scheduler");
        }
    }

    private static class ScheduledServerCommand {
        private final ServerCommand serverCommand;
        private final ScheduledFuture<?> scheduledFuture;

        private ScheduledServerCommand(ServerCommand serverCommand, ScheduledFuture<?> scheduledFuture) {
            this.serverCommand = serverCommand;
            this.scheduledFuture = scheduledFuture;
        }

        private String getName() {
            return this.serverCommand.getName();
        }

        private void cancel() {
            this.scheduledFuture.cancel(true);
        }
    }
}

