/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.googlecode.jmxtrans.ConfigurationParser;
import com.googlecode.jmxtrans.ManagedJmxTransformerProcess;
import com.googlecode.jmxtrans.classloader.ClassLoaderEnricher;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.cli.JmxTransConfigurationFactory;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.guice.JmxTransModule;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.monitoring.ManagedThreadPoolExecutor;
import com.googlecode.jmxtrans.scheduler.ServerScheduler;
import com.googlecode.jmxtrans.util.WatchDir;
import com.googlecode.jmxtrans.util.WatchedCallback;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransformer
implements WatchedCallback {
    private static final Logger log = LoggerFactory.getLogger(JmxTransformer.class);
    private final JmxTransConfiguration configuration;
    private final ConfigurationParser configurationParser;
    private final Injector injector;
    private WatchDir watcher;
    private ImmutableList<Server> masterServersList = ImmutableList.of();
    private Thread shutdownHook = new ShutdownHook();
    @Nonnull
    private final ScheduledExecutorService reloadScheduler;
    private volatile boolean isRunning = false;
    @Nonnull
    private ExecutorRepository queryExecutorRepository;
    private final ServerScheduler serverScheduler;
    @Nonnull
    private ExecutorRepository resultExecutorRepository;
    @Nonnull
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    @Nonnull
    private final MBeanServer platformMBeanServer;
    @Nullable
    private ManagedJmxTransformerProcess jmxTransformerProcessMBean;
    @Nullable
    private ImmutableList<ManagedThreadPoolExecutor> queryExecutorMBeans;
    @Nullable
    private ImmutableList<ManagedThreadPoolExecutor> resultExecutorMBeans;
    private ScheduledFuture<?> reloadScheduledFuture;

    @Inject
    public JmxTransformer(@Nonnull ServerScheduler serverScheduler, JmxTransConfiguration configuration, ConfigurationParser configurationParser, Injector injector, @Nonnull @Named(value="queryExecutorRepository") ExecutorRepository queryExecutorRepository, @Nonnull @Named(value="resultExecutorRepository") ExecutorRepository resultExecutorRepository, @Nonnull ScheduledExecutorService scheduledExecutor) {
        this.serverScheduler = serverScheduler;
        this.configuration = configuration;
        this.configurationParser = configurationParser;
        this.injector = injector;
        this.queryExecutorRepository = queryExecutorRepository;
        this.resultExecutorRepository = resultExecutorRepository;
        this.reloadScheduler = scheduledExecutor;
        this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public static void main(String[] args) throws Exception {
        JmxTransConfiguration configuration = JmxTransConfigurationFactory.fromArgs(args);
        if (configuration.isHelp()) {
            return;
        }
        JmxTransformer transformer = JmxTransformer.create(configuration);
        transformer.doMain();
    }

    public static JmxTransformer create(JmxTransConfiguration configuration) throws MalformedURLException, FileNotFoundException {
        ClassLoaderEnricher enricher = new ClassLoaderEnricher();
        for (File jar : configuration.getAdditionalJars()) {
            enricher.add(jar);
        }
        Injector injector = JmxTransModule.createInjector(configuration);
        return (JmxTransformer)injector.getInstance(JmxTransformer.class);
    }

    private void doMain() throws Exception {
        this.start();
        try {
            while (true) {
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            log.info("shutting down", (Throwable)e);
            this.unregisterMBeans();
            return;
        }
    }

    public synchronized void start() throws LifecycleException {
        if (this.isRunning) {
            throw new LifecycleException("Process already started");
        }
        log.info("Starting Jmxtrans on : {}", (Object)this.configuration.getProcessConfigDirOrFile());
        try {
            this.serverScheduler.start();
            this.startupWatchdir();
            this.initializeExecutors();
            this.registerMBeans();
            this.startupSystem();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LifecycleException(e);
        }
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.isRunning = true;
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.isRunning) {
            throw new LifecycleException("Process already stopped");
        }
        try {
            log.info("Stopping Jmxtrans");
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.stopServices();
            this.isRunning = false;
        }
        catch (LifecycleException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LifecycleException(e);
        }
    }

    private synchronized void stopServices() throws LifecycleException {
        try {
            this.serverScheduler.stop();
            for (ThreadPoolExecutor executor : this.queryExecutorRepository.getExecutors()) {
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
            for (ThreadPoolExecutor executor : this.resultExecutorRepository.getExecutors()) {
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (this.watcher != null) {
                this.watcher.stopService();
                this.watcher = null;
                log.debug("Shutdown watch service");
            }
            this.stopWriterAndClearMasterServerList();
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    private void stopWriterAndClearMasterServerList() {
        for (Server server : this.masterServersList) {
            for (OutputWriter writer : server.getOutputWriters()) {
                try {
                    writer.close();
                }
                catch (LifecycleException ex) {
                    log.error("Eror stopping writer: {}", (Object)writer);
                }
            }
            for (Query query : server.getQueries()) {
                for (OutputWriter writer : query.getOutputWriterInstances()) {
                    try {
                        writer.close();
                        log.debug("Stopped writer: {} for query: {}", (Object)writer, (Object)query);
                    }
                    catch (LifecycleException ex) {
                        log.error("Error stopping writer: {} for query: {}", new Object[]{writer, query, ex});
                    }
                }
            }
        }
        this.masterServersList = ImmutableList.of();
    }

    private void startupWatchdir() throws Exception {
        File dirToWatch = this.configuration.getProcessConfigDirOrFile().isFile() ? new File(FilenameUtils.getFullPath((String)this.configuration.getProcessConfigDirOrFile().getAbsolutePath())) : this.configuration.getProcessConfigDirOrFile();
        this.watcher = new WatchDir(dirToWatch, (WatchedCallback)this);
        this.watcher.start();
    }

    public void executeStandalone(JmxProcess process) throws Exception {
        this.masterServersList = process.getServers();
        this.serverScheduler.start();
        this.processServersIntoJobs();
        Thread.sleep(TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
    }

    private void startupSystem() throws Exception {
        this.processFilesIntoServers();
        this.processServersIntoJobs();
    }

    private void reloadSystem() throws Exception {
        this.serverScheduler.unscheduleAll();
        this.removeExecutors();
        this.processFilesIntoServers();
        this.startExecutors();
        this.processServersIntoJobs();
    }

    private void removeExecutors() throws Exception {
        log.debug("Clearing executors for reload.");
        this.unregisterExecutors(this.queryExecutorMBeans);
        this.unregisterExecutors(this.resultExecutorMBeans);
        for (Server server : this.masterServersList) {
            this.queryExecutorRepository.remove(server);
            this.resultExecutorRepository.remove(server);
        }
    }

    private void startExecutors() throws Exception {
        this.initializeExecutors();
        this.queryExecutorMBeans = this.registerExecutors(this.queryExecutorRepository);
        this.resultExecutorMBeans = this.registerExecutors(this.resultExecutorRepository);
    }

    private void initializeExecutors() throws MalformedObjectNameException {
        this.initializeExecutors(this.queryExecutorRepository);
        this.initializeExecutors(this.resultExecutorRepository);
    }

    private void initializeExecutors(ExecutorRepository executorRepository) throws MalformedObjectNameException {
        for (Server server : this.masterServersList) {
            executorRepository.put(server);
        }
    }

    private void validateSetup(Server server, ImmutableSet<Query> queries) throws ValidationException {
        for (Query q : queries) {
            this.validateSetup(server, q);
        }
    }

    private void validateSetup(Server server, Query query) throws ValidationException {
        for (OutputWriter w : query.getOutputWriterInstances()) {
            this.injector.injectMembers((Object)w);
            w.validateSetup(server, query);
        }
    }

    private void processFilesIntoServers() throws LifecycleException {
        try {
            this.stopWriterAndClearMasterServerList();
        }
        catch (Exception e) {
            log.error("Error while clearing master server list: " + e.getMessage(), (Throwable)e);
            throw new LifecycleException(e);
        }
        this.masterServersList = this.configurationParser.parseServers(this.getProcessConfigFiles(), this.configuration.isContinueOnJsonError());
    }

    private void processServersIntoJobs() throws LifecycleException {
        for (Server server : this.masterServersList) {
            try {
                for (Query query : server.getQueries()) {
                    for (OutputWriter writer : query.getOutputWriterInstances()) {
                        writer.start();
                    }
                }
                this.validateSetup(server, server.getQueries());
                this.serverScheduler.schedule(server);
            }
            catch (ValidationException ex) {
                throw new LifecycleException("Error validating json setup for query", ex);
            }
        }
    }

    private void registerMBeans() throws Exception {
        this.jmxTransformerProcessMBean = new ManagedJmxTransformerProcess(this, this.configuration);
        this.platformMBeanServer.registerMBean(this.jmxTransformerProcessMBean, this.jmxTransformerProcessMBean.getObjectName());
        this.queryExecutorMBeans = this.registerExecutors(this.queryExecutorRepository);
        this.resultExecutorMBeans = this.registerExecutors(this.resultExecutorRepository);
    }

    private ImmutableList<ManagedThreadPoolExecutor> registerExecutors(ExecutorRepository executorRepository) throws Exception {
        ImmutableList.Builder executorMBeansBuilder = ImmutableList.builder();
        for (ManagedThreadPoolExecutor executorMBean : executorRepository.getMBeans()) {
            this.platformMBeanServer.registerMBean(executorMBean, executorMBean.getObjectName());
            executorMBeansBuilder.add((Object)executorMBean);
        }
        return executorMBeansBuilder.build();
    }

    private void unregisterMBeans() throws Exception {
        if (this.jmxTransformerProcessMBean != null) {
            this.platformMBeanServer.unregisterMBean(this.jmxTransformerProcessMBean.getObjectName());
        }
        this.unregisterExecutors(this.queryExecutorMBeans);
        this.unregisterExecutors(this.resultExecutorMBeans);
    }

    private void unregisterExecutors(ImmutableList<ManagedThreadPoolExecutor> executorMBeans) throws Exception {
        if (executorMBeans != null) {
            for (ManagedThreadPoolExecutor executorMBean : executorMBeans) {
                this.platformMBeanServer.unregisterMBean(executorMBean.getObjectName());
            }
        }
    }

    @VisibleForTesting
    Date computeSpreadStartDate(int runPeriod) {
        long spread = this.random.nextLong(TimeUnit.MILLISECONDS.convert(runPeriod, TimeUnit.SECONDS));
        return new Date(new Date().getTime() + spread);
    }

    @VisibleForTesting
    List<File> getProcessConfigFiles() {
        File configurationDirOrFile = this.configuration.getProcessConfigDirOrFile();
        if (configurationDirOrFile == null) {
            throw new IllegalStateException("Configuration should specify configuration directory or file, with -j of -f option");
        }
        File[] files = configurationDirOrFile.isFile() ? new File[]{configurationDirOrFile} : Optional.ofNullable(configurationDirOrFile.listFiles()).orElse(new File[0]);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (!this.isProcessConfigFile(file)) continue;
            result.add(file);
        }
        return result;
    }

    private boolean isProcessConfigFile(File file) {
        if (this.configuration.getProcessConfigDirOrFile().isFile()) {
            return file.equals(this.configuration.getProcessConfigDirOrFile());
        }
        if (file.exists() && !file.isFile()) {
            return false;
        }
        String fileName = file.getName();
        return !fileName.startsWith(".") && (fileName.endsWith(".json") || fileName.endsWith(".yml") || fileName.endsWith(".yaml"));
    }

    private void scheduleReload() {
        if (this.reloadScheduledFuture != null) {
            this.reloadScheduledFuture.cancel(false);
            this.reloadScheduledFuture = null;
        }
        this.reloadScheduledFuture = this.reloadScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    JmxTransformer.this.reloadSystem();
                }
                catch (Exception e) {
                    log.error("Error during reload.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void handleFileEvent(File file, String event) throws Exception {
        if (this.isProcessConfigFile(file)) {
            log.info("Configuration file {}: {}", (Object)event, (Object)file);
            this.scheduleReload();
        }
    }

    public void fileModified(File file) throws Exception {
        this.handleFileEvent(file, "modified");
    }

    public void fileDeleted(File file) throws Exception {
        this.handleFileEvent(file, "deleted");
    }

    public void fileAdded(File file) throws Exception {
        this.handleFileEvent(file, "added");
    }

    protected class ShutdownHook
    extends Thread {
        protected ShutdownHook() {
        }

        @Override
        public void run() {
            try {
                JmxTransformer.this.stopServices();
            }
            catch (LifecycleException e) {
                log.error("Error shutdown hook", (Throwable)e);
            }
        }
    }
}

