/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Joiner;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.annotation.Nonnull;

public class FileConfiguration
implements IDefaultProvider {
    @Nonnull
    private final JmxTransConfiguration configuration;

    public FileConfiguration(@Nonnull JmxTransConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getDefaultValueFor(String optionName) {
        for (Field field : JmxTransConfiguration.class.getDeclaredFields()) {
            Parameter parameterAnnot = field.getAnnotation(Parameter.class);
            if (parameterAnnot == null) continue;
            for (String name : parameterAnnot.names()) {
                try {
                    if (!name.equals(optionName)) continue;
                    Object value = FileConfiguration.getField(field, this.configuration);
                    return FileConfiguration.toString(value);
                }
                catch (IllegalAccessException e) {
                    throw new ParameterException("Invalid option " + optionName);
                }
            }
        }
        throw new ParameterException("Unsupported option " + optionName);
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return null;
            }
            return Joiner.on((char)',').join((Iterable)collection);
        }
        return value.toString();
    }

    private static Object getField(Field field, Object target) throws IllegalAccessException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(target);
    }
}

