/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.googlecode.jmxtrans.cli.JCommanderArgumentParser;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxTransConfigurationFactory.class);

    public static JmxTransConfiguration fromProperties(File configFile) throws IOException {
        Properties properties = new Properties();
        File lConfigFile = null;
        try (InputStream in = JmxTransConfiguration.class.getResourceAsStream("/jmxtrans.properties");){
            properties.load(in);
        }
        if (configFile != null) {
            lConfigFile = configFile;
            in = new FileInputStream(configFile);
            var4_4 = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (var4_4 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        File defaultSystemProperties = new File("/etc/jmxtrans/jmxtrans.properties");
        if (defaultSystemProperties.isFile()) {
            lConfigFile = defaultSystemProperties;
            try (FileInputStream in = new FileInputStream(defaultSystemProperties);){
                properties.load(in);
            }
        }
        JmxTransConfiguration configuration = new JmxTransConfiguration();
        if (lConfigFile != null) {
            LOGGER.info("Loading config file {}", (Object)lConfigFile);
        }
        configuration.loadProperties(properties);
        configuration.setConfigFile(lConfigFile);
        return configuration;
    }

    public static JmxTransConfiguration fromArgs(String ... args) throws IOException {
        return new JCommanderArgumentParser().parseOptions(args);
    }
}

