/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.executors;

import com.google.common.util.concurrent.MoreExecutors;
import com.googlecode.jmxtrans.executors.ExecutorFactory;
import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.monitoring.ManagedThreadPoolExecutor;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.management.MalformedObjectNameException;

public class SeparateExecutorRepository
implements ExecutorRepository {
    @Nonnull
    private final ConcurrentHashMap<Server, ThreadPoolExecutor> repository;
    @Nonnull
    private final ExecutorFactory executorFactory;
    @Nonnull
    private final ConcurrentHashMap<Server, ManagedThreadPoolExecutor> mBeans;

    public SeparateExecutorRepository(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
        this.repository = new ConcurrentHashMap();
        this.mBeans = new ConcurrentHashMap();
    }

    @Override
    public Collection<ThreadPoolExecutor> getExecutors() {
        return this.repository.values();
    }

    @Override
    public ThreadPoolExecutor getExecutor(Server server) {
        return this.repository.get(server);
    }

    @Override
    public Collection<ManagedThreadPoolExecutor> getMBeans() {
        return this.mBeans.values();
    }

    @Override
    public void put(Server server) throws MalformedObjectNameException {
        ManagedThreadPoolExecutor managedThreadPoolExecutor = this.executorFactory.create(server.getId());
        this.repository.put(server, managedThreadPoolExecutor.getExecutor());
        this.mBeans.put(server, managedThreadPoolExecutor);
    }

    @Override
    public void remove(Server server) {
        ExecutorService executor = this.repository.remove(server);
        if (executor != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        this.mBeans.remove(server);
    }
}

