/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming;

import com.google.common.base.Joiner;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import java.util.List;

public final class KeyUtils {
    private KeyUtils() {
    }

    public static String getKeyString(Server server, Query query, Result result, List<String> typeNames, String rootPrefix) {
        StringBuilder sb = new StringBuilder();
        KeyUtils.addRootPrefix(rootPrefix, sb);
        KeyUtils.addAlias(server, sb);
        KeyUtils.addSeparator(sb);
        KeyUtils.addMBeanIdentifier(query, result, sb);
        KeyUtils.addSeparator(sb);
        KeyUtils.addTypeName(query, result, typeNames, sb);
        KeyUtils.addKeyString(query, result, sb);
        return sb.toString();
    }

    public static String getKeyString(Query query, Result result, List<String> typeNames) {
        StringBuilder sb = new StringBuilder();
        KeyUtils.addMBeanIdentifier(query, result, sb);
        KeyUtils.addSeparator(sb);
        KeyUtils.addTypeName(query, result, typeNames, sb);
        KeyUtils.addKeyString(query, result, sb);
        return sb.toString();
    }

    private static void addSeparator(StringBuilder sb) {
        if (sb.length() > 0 && !sb.substring(sb.length() - 1).equals(".")) {
            sb.append(".");
        }
    }

    public static String getPrefixedKeyString(Query query, Result result, List<String> typeNames) {
        StringBuilder sb = new StringBuilder();
        KeyUtils.addTypeName(query, result, typeNames, sb);
        KeyUtils.addKeyString(query, result, sb);
        return sb.toString();
    }

    private static void addRootPrefix(String rootPrefix, StringBuilder sb) {
        if (rootPrefix != null && rootPrefix.length() > 0) {
            sb.append(rootPrefix);
            sb.append(".");
        }
    }

    private static void addAlias(Server server, StringBuilder sb) {
        String alias;
        if (server.getAlias() != null) {
            alias = server.getAlias();
        } else {
            alias = server.getHost() + "_" + server.getPort();
            alias = StringUtils.cleanupStr(alias);
        }
        sb.append(alias);
    }

    private static void addMBeanIdentifier(Query query, Result result, StringBuilder sb) {
        if (result.getKeyAlias() != null) {
            sb.append(result.getKeyAlias());
        } else if (query.isUseObjDomainAsKey()) {
            sb.append(StringUtils.cleanupStr(result.getObjDomain(), query.isAllowDottedKeys()));
        } else {
            sb.append(StringUtils.cleanupStr(result.getClassName()));
        }
    }

    private static void addTypeName(Query query, Result result, List<String> typeNames, StringBuilder sb) {
        String typeName = StringUtils.cleanupStr(query.makeTypeNameValueString(typeNames, result.getTypeName()), query.isAllowDottedKeys());
        if (typeName != null && typeName.length() > 0) {
            sb.append(typeName);
            sb.append(".");
        }
    }

    private static void addKeyString(Query query, Result result, StringBuilder sb) {
        String keyStr = KeyUtils.getValueKey(result);
        sb.append(StringUtils.cleanupStr(keyStr, query.isAllowDottedKeys()));
    }

    public static String getValueKey(Result result) {
        if (result.getValuePath().isEmpty()) {
            return result.getAttributeName();
        }
        return result.getAttributeName() + "." + KeyUtils.getValuePathString(result);
    }

    public static String getValuePathString(Result result) {
        return Joiner.on((char)'.').join(result.getValuePath());
    }
}

