/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.results.BooleanAsNumberValueTransformer;
import com.googlecode.jmxtrans.model.results.IdentityValueTransformer;
import com.googlecode.jmxtrans.model.results.ResultValuesTransformer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class ResultTransformerOutputWriter<T extends OutputWriter>
extends OutputWriterAdapter {
    @Nonnull
    private final ResultValuesTransformer resultValuesTransformer;
    @Nonnull
    private final T target;

    public ResultTransformerOutputWriter(@Nonnull ResultValuesTransformer resultValuesTransformer, @Nonnull T target) {
        this.resultValuesTransformer = resultValuesTransformer;
        this.target = target;
    }

    @Override
    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        this.target.doWrite(server, query, (Iterable)StreamSupport.stream(results.spliterator(), false).map(this.resultValuesTransformer).collect(ImmutableList.toImmutableList()));
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> booleanToNumber(boolean booleanToNumber, T target) {
        if (booleanToNumber) {
            return ResultTransformerOutputWriter.booleanToNumber(target);
        }
        return ResultTransformerOutputWriter.identity(target);
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> booleanToNumber(T target) {
        return new ResultTransformerOutputWriter<T>(new ResultValuesTransformer(new BooleanAsNumberValueTransformer(1, 0)), target);
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> identity(T target) {
        return new ResultTransformerOutputWriter<T>(new ResultValuesTransformer(new IdentityValueTransformer()), target);
    }

    @Override
    public void close() throws LifecycleException {
        this.target.close();
    }

    @VisibleForTesting
    T getTarget() {
        return this.target;
    }
}

