/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.monitoring;

import com.googlecode.jmxtrans.monitoring.ThreadPoolExecutorMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ManagedThreadPoolExecutor
implements ThreadPoolExecutorMXBean {
    @Nonnull
    private final ThreadPoolExecutor executor;
    private ObjectName objectName;

    public ManagedThreadPoolExecutor(@Nonnull ThreadPoolExecutor executor, @Nonnull String name) throws MalformedObjectNameException {
        this.executor = executor;
        this.objectName = new ObjectName("com.googlecode.jmxtrans:Type=ThreadPoolExecutor,PoolName=" + name);
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return this.executor.allowsCoreThreadTimeOut();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public long getKeepAliveTimeSeconds() {
        return this.executor.getKeepAliveTime(TimeUnit.SECONDS);
    }

    @Override
    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public long getTaskCount() {
        return this.executor.getTaskCount();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        return this.executor.isTerminating();
    }

    @Override
    public int workQueueRemainingCapacity() {
        return this.executor.getQueue().remainingCapacity();
    }

    @Override
    public int workQueueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

