/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.scheduler;

import com.googlecode.jmxtrans.executors.ExecutorRepository;
import com.googlecode.jmxtrans.jmx.ProcessQueryThread;
import com.googlecode.jmxtrans.jmx.ResultProcessor;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.scheduler.ServerScheduler;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCommand
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ServerScheduler.class);
    private final Server server;
    private final ExecutorRepository queryExecutorRepository;
    private final ResultProcessor resultProcessor;

    public ServerCommand(Server server, ExecutorRepository queryExecutorRepository, ResultProcessor resultProcessor) {
        this.server = server;
        this.queryExecutorRepository = queryExecutorRepository;
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void run() {
        log.debug("+++++ Started server job {}", (Object)this.server);
        try {
            ThreadPoolExecutor executor = this.queryExecutorRepository.getExecutor(this.server);
            for (Query query : this.server.getQueries()) {
                ProcessQueryThread pqt = new ProcessQueryThread(this.resultProcessor, this.server, query);
                try {
                    executor.submit(pqt);
                }
                catch (RejectedExecutionException ree) {
                    log.error("Could not submit query {}. You could try to size the 'queryProcessorExecutor' to a larger size.", (Object)pqt, (Object)ree);
                }
            }
            log.debug("+++++ Finished server job {}", (Object)this.server);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("+++++ Failed server job " + this.server, (Throwable)e);
            }
            log.warn("+++++ Failed server job {}: {} {}", new Object[]{this.server, e.getClass().getName(), e.getMessage()});
        }
    }

    public String getName() {
        return this.server.getHost() + ":" + this.server.getPort();
    }
}

