/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.googlecode.jmxtrans.JmxTransformer;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.guice.JmxTransModule;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.GraphiteWriter;
import com.googlecode.jmxtrans.util.JsonPrinter;

public class ActiveMQ {
    private static final String GW_HOST = "192.168.192.133";

    public static void main(String[] args) throws Exception {
        Server.Builder serverBuilder = Server.builder().setHost("w2").setPort("1105").setAlias("w2_activemq_1105");
        GraphiteWriter gw = GraphiteWriter.builder().addTypeName("destinationName").addTypeName("Destination").setDebugEnabled(true).setHost(GW_HOST).setPort(2003).build();
        Query q = Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Type=Subscription,clientId=*,consumerId=*,destinationName=*,destinationType=Queue,persistentMode=Non-Durable").addAttr(new String[]{"PendingQueueSize"}).addAttr(new String[]{"DispatchedQueueSize"}).addAttr(new String[]{"EnqueueCounter"}).addAttr(new String[]{"DequeueCounter"}).addAttr(new String[]{"MessageCountAwaitingAcknowledge"}).addAttr(new String[]{"DispachedCounter"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q);
        Query q2 = Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Destination=ActiveMQ.Advisory.Consumer.Queue.*,Type=Topic").addAttr(new String[]{"QueueSize"}).addAttr(new String[]{"MaxEnqueueTime"}).addAttr(new String[]{"MinEnqueueTime"}).addAttr(new String[]{"AverageEnqueueTime"}).addAttr(new String[]{"InFlightCount"}).addAttr(new String[]{"ConsumerCount"}).addAttr(new String[]{"ProducerCount"}).addAttr(new String[]{"DispatchCount"}).addAttr(new String[]{"DequeueCount"}).addAttr(new String[]{"EnqueueCount"}).addAttr(new String[]{"Subscriptions"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q2);
        Query q3 = Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Destination=*,Type=Queue").addAttr(new String[]{"QueueSize"}).addAttr(new String[]{"MaxEnqueueTime"}).addAttr(new String[]{"MinEnqueueTime"}).addAttr(new String[]{"AverageEnqueueTime"}).addAttr(new String[]{"InFlightCount"}).addAttr(new String[]{"ConsumerCount"}).addAttr(new String[]{"ProducerCount"}).addAttr(new String[]{"DispatchCount"}).addAttr(new String[]{"DequeueCount"}).addAttr(new String[]{"EnqueueCount"}).addAttr(new String[]{"Subscriptions"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q3);
        Query q4 = Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Destination=*,Type=Topic").addAttr(new String[]{"QueueSize"}).addAttr(new String[]{"MaxEnqueueTime"}).addAttr(new String[]{"MinEnqueueTime"}).addAttr(new String[]{"AverageEnqueueTime"}).addAttr(new String[]{"InFlightCount"}).addAttr(new String[]{"ConsumerCount"}).addAttr(new String[]{"ProducerCount"}).addAttr(new String[]{"DispatchCount"}).addAttr(new String[]{"DequeueCount"}).addAttr(new String[]{"EnqueueCount"}).addAttr(new String[]{"Subscriptions"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q4);
        Query q5 = Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Type=Broker").addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q5);
        Query q6 = Query.builder().setObj("java.lang:type=Memory").addAttr(new String[]{"HeapMemoryUsage"}).addAttr(new String[]{"NonHeapMemoryUsage"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q6);
        Query q7 = Query.builder().setObj("java.lang:type=Threading").addAttr(new String[]{"DaemonThreadCount"}).addAttr(new String[]{"PeakThreadCount"}).addAttr(new String[]{"ThreadCount"}).addAttr(new String[]{"CurrentThreadCpuTime"}).addAttr(new String[]{"CurrentThreadUserTime"}).addAttr(new String[]{"TotalStartedThreadCount"}).addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q7);
        Query q8 = Query.builder().setObj("java.lang:name=*,type=GarbageCollector").addKey("committed").addKey("init").addKey("max").addKey("used").addKey("duration").addKey("CollectionCount").addKey("CollectionTime").addOutputWriter((OutputWriterFactory)gw).build();
        serverBuilder.addQuery(q8);
        Query q9 = Query.builder().setObj("java.lang:type=MemoryPool,name=*").addOutputWriter((OutputWriterFactory)GraphiteWriter.builder().addTypeName("name").setDebugEnabled(true).setHost(GW_HOST).setPort(2003).build()).build();
        serverBuilder.addQuery(q9);
        JmxProcess process = new JmxProcess(serverBuilder.build());
        new JsonPrinter(System.out).prettyPrint(process);
        Injector injector = Guice.createInjector((Module[])new Module[]{new JmxTransModule(new JmxTransConfiguration())});
        JmxTransformer transformer = (JmxTransformer)injector.getInstance(JmxTransformer.class);
        transformer.executeStandalone(process);
    }
}

