/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.googlecode.jmxtrans.model.JmxProcess;
import java.io.OutputStream;
import java.io.PrintStream;

public class JsonPrinter {
    private final PrintStream out;
    private final ObjectMapper mapper;
    private final ObjectWriter prettyPrintingWriter;

    public JsonPrinter(PrintStream out) {
        this.out = out;
        this.mapper = new ObjectMapper();
        this.mapper.getSerializationConfig().without(SerializationFeature.WRITE_NULL_MAP_VALUES);
        this.prettyPrintingWriter = this.mapper.writerWithDefaultPrettyPrinter();
    }

    public void print(JmxProcess process) throws Exception {
        this.mapper.writeValue((OutputStream)this.out, (Object)process);
    }

    public void prettyPrint(JmxProcess process) throws Exception {
        this.prettyPrintingWriter.writeValue((OutputStream)this.out, (Object)process);
    }
}

