/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeWalker3 {
    private static final Logger log = LoggerFactory.getLogger(TreeWalker3.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Server server = Server.builder().setHost("w2").setPort("1105").build();
        try (JMXConnector conn = null;){
            conn = server.getServerConnection();
            MBeanServerConnection mbeanServer = conn.getMBeanServerConnection();
            TreeWalker3 tw = new TreeWalker3();
            tw.walkTree(mbeanServer, server);
        }
    }

    public void walkTree(MBeanServerConnection connection, Server server) throws Exception {
        Set<ObjectName> mbeans = connection.queryNames(null, null);
        HashMap output = Maps.newHashMap();
        for (ObjectName objectName : mbeans) {
            MBeanInfo info = connection.getMBeanInfo(objectName);
            MBeanAttributeInfo[] attrs = info.getAttributes();
            Query.Builder queryBuilder = Query.builder().setObj(objectName.getCanonicalName());
            ResultCapture resultCapture = new ResultCapture();
            queryBuilder.addOutputWriterFactory((OutputWriterFactory)resultCapture);
            for (MBeanAttributeInfo attrInfo : attrs) {
                queryBuilder.addAttr(new String[]{attrInfo.getName()});
            }
            Query query = queryBuilder.build();
            try {
                Iterable results = server.execute(query);
                query.runOutputWritersForQuery(server, results);
            }
            catch (AttributeNotFoundException anfe) {
                log.error("Error", (Throwable)anfe);
            }
            for (Result result : resultCapture.results) {
                output.put(result.getTypeName(), query.getAttr().toString());
            }
        }
        for (Map.Entry entry : output.entrySet()) {
            log.debug((String)entry.getKey());
            log.debug((String)entry.getValue());
            log.debug("-----------------------------------------");
        }
    }

    private static final class ResultCapture
    extends OutputWriterAdapter
    implements OutputWriterFactory {
        private List<Result> results;

        private ResultCapture() {
        }

        public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
            this.results = ImmutableList.copyOf(results);
        }

        public OutputWriter create() {
            return this;
        }
    }
}

