/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.google.inject.Injector;
import com.googlecode.jmxtrans.JmxTransformer;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.example.JsonPrinter;
import com.googlecode.jmxtrans.guice.JmxTransModule;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.RRDToolWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;

public class ActiveMQ2 {
    private static final JsonPrinter jsonPrinter = new JsonPrinter(System.out);

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Path to RRD binary is hardcoded as this is example code")
    public static void main(String[] args) throws Exception {
        File outputFile = new File("target/w2-TEST.rrd");
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IOException("Could not create output file");
        }
        RRDToolWriter gw = RRDToolWriter.builder().setTemplateFile(new File("memorypool-rrd-template.xml")).setOutputFile(outputFile).setBinaryPath(new File("/opt/local/bin")).setDebugEnabled(true).setGenerate(Boolean.valueOf(true)).addTypeName("Destination").build();
        JmxProcess process = new JmxProcess(Server.builder().setHost("w2").setPort("1105").setAlias("w2_activemq_1105").addQuery(Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Type=Queue,Destination=*").addAttr(new String[]{"QueueSize"}).addAttr(new String[]{"MaxEnqueueTime"}).addAttr(new String[]{"MinEnqueueTime"}).addAttr(new String[]{"AverageEnqueueTime"}).addAttr(new String[]{"InFlightCount"}).addAttr(new String[]{"ConsumerCount"}).addAttr(new String[]{"ProducerCount"}).addAttr(new String[]{"DispatchCount"}).addAttr(new String[]{"DequeueCount"}).addAttr(new String[]{"EnqueueCount"}).addOutputWriterFactory((OutputWriterFactory)gw).build()).addQuery(Query.builder().setObj("org.apache.activemq:BrokerName=localhost,Type=Topic,Destination=*").addAttr(new String[]{"QueueSize"}).addAttr(new String[]{"MaxEnqueueTime"}).addAttr(new String[]{"MinEnqueueTime"}).addAttr(new String[]{"AverageEnqueueTime"}).addAttr(new String[]{"InFlightCount"}).addAttr(new String[]{"ConsumerCount"}).addAttr(new String[]{"ProducerCount"}).addAttr(new String[]{"DispatchCount"}).addAttr(new String[]{"DequeueCount"}).addAttr(new String[]{"EnqueueCount"}).addOutputWriterFactory((OutputWriterFactory)gw).build()).build());
        jsonPrinter.prettyPrint(process);
        Injector injector = JmxTransModule.createInjector((JmxTransConfiguration)new JmxTransConfiguration());
        JmxTransformer transformer = (JmxTransformer)injector.getInstance(JmxTransformer.class);
        transformer.executeStandalone(process);
    }
}

