/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.googlecode.jmxtrans.JmxTransformer;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.example.JsonPrinter;
import com.googlecode.jmxtrans.guice.JmxTransModule;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.GraphiteWriter;
import com.googlecode.jmxtrans.model.output.StdOutWriter;
import java.util.Collections;
import java.util.HashMap;

public class InterestingInfo {
    private static final JsonPrinter printer = new JsonPrinter(System.out);

    public static void main(String[] args) throws Exception {
        Server.Builder serverBuilder = Server.builder().setHost("w2").setPort("1099");
        HashMap settings = Maps.newHashMap();
        settings.put("host", "192.168.192.133");
        settings.put("port", 2003);
        GraphiteWriter gw = GraphiteWriter.builder().setHost("192.168.192.133").setPort(2003).build();
        StdOutWriter sw = new StdOutWriter(ImmutableList.of(), false, Boolean.valueOf(false), null, Collections.emptyMap());
        Query q = Query.builder().setObj("java.lang:type=Memory").addAttr(new String[]{"HeapMemoryUsage"}).addAttr(new String[]{"NonHeapMemoryUsage"}).addOutputWriterFactories(new OutputWriterFactory[]{gw, sw}).build();
        serverBuilder.addQuery(q);
        Query q2 = Query.builder().setObj("java.lang:type=Threading").addAttr(new String[]{"DaemonThreadCount"}).addAttr(new String[]{"PeakThreadCount"}).addAttr(new String[]{"ThreadCount"}).addOutputWriterFactories(new OutputWriterFactory[]{gw, sw}).build();
        serverBuilder.addQuery(q2);
        Query q3 = Query.builder().setObj("java.lang:name=ConcurrentMarkSweep,type=GarbageCollector").addAttr(new String[]{"LastGcInfo"}).addOutputWriterFactories(new OutputWriterFactory[]{gw, sw}).build();
        serverBuilder.addQuery(q3);
        Query q4 = Query.builder().setObj("java.lang:name=ParNew,type=GarbageCollector").addAttr(new String[]{"LastGcInfo"}).addOutputWriterFactories(new OutputWriterFactory[]{gw, sw}).build();
        serverBuilder.addQuery(q4);
        JmxProcess process = new JmxProcess(serverBuilder.build());
        printer.prettyPrint(process);
        Injector injector = JmxTransModule.createInjector((JmxTransConfiguration)new JmxTransConfiguration());
        JmxTransformer transformer = (JmxTransformer)injector.getInstance(JmxTransformer.class);
        transformer.executeStandalone(process);
    }
}

