/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.example;

import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.StdOutWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeWalker2 {
    private static final Logger log = LoggerFactory.getLogger(TreeWalker2.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Server server = Server.builder().setHost("localhost").setPort("1099").build();
        try (JMXConnector conn = null;){
            conn = server.getServerConnection();
            MBeanServerConnection mbeanServer = conn.getMBeanServerConnection();
            TreeWalker2 tw = new TreeWalker2();
            tw.walkTree(mbeanServer, server);
        }
    }

    public void walkTree(MBeanServerConnection connection, Server server) throws Exception {
        Set<ObjectName> mbeans = connection.queryNames(null, null);
        for (ObjectName name : mbeans) {
            MBeanInfo info = connection.getMBeanInfo(name);
            MBeanAttributeInfo[] attrs = info.getAttributes();
            Query.Builder queryBuilder = Query.builder().setObj(name.getCanonicalName()).addOutputWriterFactory((OutputWriterFactory)new StdOutWriter(ImmutableList.of(), false, Boolean.valueOf(false), null, Collections.emptyMap()));
            for (MBeanAttributeInfo attrInfo : attrs) {
                queryBuilder.addAttr(new String[]{attrInfo.getName()});
            }
            Query query = queryBuilder.build();
            try {
                Collection results = server.execute(query);
                query.runOutputWritersForQuery(server, (Iterable)results);
            }
            catch (AttributeNotFoundException anfe) {
                log.error("Error", (Throwable)anfe);
            }
        }
    }
}

