/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.ObjectToDouble;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchWriter.class);
    private AmazonCloudWatchClient cloudWatchClient;
    private String namespace;
    private final ObjectToDouble toDoubleConverter = new ObjectToDouble();

    @JsonCreator
    public CloudWatchWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.namespace = (String)MoreObjects.firstNonNull((Object)namespace, (Object)((String)this.getSettings().get("namespace")));
        if (Strings.isNullOrEmpty((String)this.namespace)) {
            throw new IllegalArgumentException("namespace cannot be null or empty");
        }
    }

    @JsonIgnore
    @VisibleForTesting
    void setCloudWatchClient(AmazonCloudWatchClient cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        if (this.cloudWatchClient == null) {
            this.cloudWatchClient = new AmazonCloudWatchClient((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
            Region awsRegion = Regions.getCurrentRegion();
            if (awsRegion == null) {
                throw new ValidationException("Problems getting metadata", query);
            }
            this.cloudWatchClient.setRegion(awsRegion);
        }
    }

    protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        PutMetricDataRequest metricDataRequest = new PutMetricDataRequest();
        metricDataRequest.setNamespace(this.namespace);
        ArrayList<MetricDatum> metricDatumList = new ArrayList<MetricDatum>();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry<String, Object> values : resultValues.entrySet()) {
                try {
                    metricDatumList.add(this.processResult(result, values));
                }
                catch (IllegalArgumentException iae) {
                    log.error("Could not convert result to double", (Throwable)iae);
                }
            }
        }
        metricDataRequest.setMetricData(metricDatumList);
        this.cloudWatchClient.putMetricData(metricDataRequest);
    }

    private MetricDatum processResult(Result result, Map.Entry<String, Object> values) {
        MetricDatum metricDatum = new MetricDatum();
        if (result.getAttributeName().equals(values.getKey())) {
            metricDatum.setMetricName(result.getAttributeName());
        } else {
            metricDatum.setMetricName(result.getAttributeName() + "_" + values.getKey());
        }
        metricDatum.setValue(this.toDoubleConverter.apply(values.getValue()));
        metricDatum.setTimestamp(new Date());
        return metricDatum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private String namespace;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CloudWatchWriter build() {
            return new CloudWatchWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.namespace, null);
        }
    }
}

