/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.MapEntryToDimension;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.util.ObjectToDouble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchWriter
implements OutputWriterFactory {
    private static final Logger log = LoggerFactory.getLogger(CloudWatchWriter.class);
    public static final MapEntryToDimension MAP_ENTRY_TO_DIMENSION = new MapEntryToDimension();
    private final String namespace;
    private final Iterable<Map<String, Object>> dimensions;
    private final boolean booleanAsNumber;

    @JsonCreator
    public CloudWatchWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="dimensions") Collection<Map<String, Object>> dimensions, @JsonProperty(value="settings") Map<String, Object> settings) {
        this.booleanAsNumber = booleanAsNumber;
        this.namespace = (String)MoreObjects.firstNonNull((Object)namespace, (Object)((String)settings.get("namespace")));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.namespace) ? 1 : 0) != 0, (Object)"namespace cannot be null or empty");
        this.dimensions = (Iterable)MoreObjects.firstNonNull(dimensions, (Object)((Collection)settings.get("dimensions")));
    }

    private AmazonCloudWatchClient createCloudWatchClient() {
        AmazonCloudWatchClient cloudWatchClient = new AmazonCloudWatchClient((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        cloudWatchClient.setRegion((Region)Preconditions.checkNotNull((Object)Regions.getCurrentRegion(), (Object)"Problems getting AWS metadata"));
        return cloudWatchClient;
    }

    private ImmutableList<Dimension> createDimensions(Iterable<Map<String, Object>> dimensions) {
        if (dimensions == null) {
            return ImmutableList.of();
        }
        return FluentIterable.from(dimensions).transform((Function)MAP_ENTRY_TO_DIMENSION).toList();
    }

    public OutputWriter create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, (OutputWriter)new Writer(this.namespace, (AmazonCloudWatch)this.createCloudWatchClient(), (ImmutableCollection<Dimension>)this.createDimensions(this.dimensions)));
    }

    public static class Writer
    extends OutputWriterAdapter {
        @Nonnull
        private final String namespace;
        @Nonnull
        private final AmazonCloudWatch cloudWatchClient;
        @Nonnull
        private final ObjectToDouble toDoubleConverter = new ObjectToDouble();
        @Nonnull
        private final ImmutableCollection<Dimension> dimensions;

        public Writer(@Nonnull String namespace, @Nonnull AmazonCloudWatch cloudWatchClient, @Nonnull ImmutableCollection<Dimension> dimensions) {
            this.namespace = namespace;
            this.cloudWatchClient = cloudWatchClient;
            this.dimensions = dimensions;
        }

        public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
            PutMetricDataRequest metricDataRequest = new PutMetricDataRequest();
            metricDataRequest.setNamespace(this.namespace);
            ArrayList<MetricDatum> metricDatumList = new ArrayList<MetricDatum>();
            for (Result result : results) {
                try {
                    metricDatumList.add(this.processResult(result));
                }
                catch (IllegalArgumentException iae) {
                    log.error("Could not convert result to double", (Throwable)iae);
                }
            }
            metricDataRequest.setMetricData(metricDatumList);
            this.cloudWatchClient.putMetricData(metricDataRequest);
        }

        private MetricDatum processResult(Result result) {
            MetricDatum metricDatum = new MetricDatum();
            if (result.getValuePath().isEmpty()) {
                metricDatum.setMetricName(result.getAttributeName());
            } else {
                metricDatum.setMetricName(result.getAttributeName() + "_" + KeyUtils.getValuePathString((Result)result));
            }
            metricDatum.setDimensions(this.dimensions);
            metricDatum.setValue(this.toDoubleConverter.apply(result.getValue()));
            metricDatum.setTimestamp(new Date());
            return metricDatum;
        }

        public void close() throws LifecycleException {
            this.cloudWatchClient.shutdown();
        }
    }
}

