/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.util.EC2MetadataUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class MapEntryToDimension
implements Function<Map<String, Object>, Dimension> {
    private static final Logger log = LoggerFactory.getLogger(MapEntryToDimension.class);
    private static final String NAME = "name";
    private static final String VALUE = "value";

    MapEntryToDimension() {
    }

    @Override
    @Nullable
    public Dimension apply(Map<String, Object> dimension) {
        String name = null;
        String value = null;
        if (dimension == null) {
            return null;
        }
        if (dimension.containsKey(NAME)) {
            name = String.valueOf(dimension.get(NAME));
        }
        if (dimension.containsKey(VALUE)) {
            value = String.valueOf(dimension.get(VALUE));
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException(String.format("Incomplete dimension: Missing non-null '%s' and '%s' in '%s'", NAME, VALUE, dimension.toString()));
        }
        if (value.startsWith("$")) {
            try {
                Method m = EC2MetadataUtils.class.getMethod("get" + value.substring(1), new Class[0]);
                value = String.valueOf(m.invoke(null, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                log.warn("Could not resolve {} via a getters on {}!", new Object[]{value, EC2MetadataUtils.class.getName(), e});
            }
            catch (IllegalAccessException e) {
                log.warn("Could not load {} via a getters on {}!", new Object[]{value, EC2MetadataUtils.class.getName(), e});
            }
            catch (InvocationTargetException e) {
                log.warn("Could not retrieve {} via a getters on {}!", new Object[]{value, EC2MetadataUtils.class.getName(), e});
            }
        }
        return new Dimension().withName(name).withValue(value);
    }
}

