/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class GraphiteWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(GraphiteWriter.class);
    private static final String DEFAULT_ROOT_PREFIX = "servers";
    private GenericKeyedObjectPool<InetSocketAddress, Socket> pool;
    private final String rootPrefix;
    private final InetSocketAddress address;

    @JsonCreator
    public GraphiteWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.rootPrefix = PropertyResolver.resolveProps((String)((String)this.firstNonNull(rootPrefix, (String)this.getSettings().get("rootPrefix"), DEFAULT_ROOT_PREFIX)));
        host = PropertyResolver.resolveProps((String)host);
        if (host == null) {
            host = (String)this.getSettings().get("host");
        }
        if (host == null) {
            throw new NullPointerException("Host cannot be null.");
        }
        if (port == null) {
            port = Settings.getIntegerSetting((Map)this.getSettings(), (String)"port", null);
        }
        if (port == null) {
            throw new NullPointerException("Port cannot be null.");
        }
        this.address = new InetSocketAddress(host, (int)port);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        Socket socket = null;
        PrintWriter writer = null;
        try {
            socket = (Socket)this.pool.borrowObject((Object)this.address);
            writer = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8), true);
            List typeNames = this.getTypeNames();
            for (Result result : results) {
                log.debug("Query result: {}", (Object)result);
                ImmutableMap resultValues = result.getValues();
                if (resultValues == null) continue;
                for (Map.Entry values : resultValues.entrySet()) {
                    Object value = values.getValue();
                    if (NumberUtils.isNumeric(value)) {
                        String line = KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, (String)this.rootPrefix).replaceAll("[()]", "_") + " " + value.toString() + " " + result.getEpoch() / 1000L + "\n";
                        log.debug("Graphite Message: {}", (Object)line);
                        writer.write(line);
                        continue;
                    }
                    log.warn("Unable to submit non-numeric value to Graphite: [{}] from result [{}]", value, (Object)result);
                }
            }
        }
        finally {
            if (writer != null && writer.checkError()) {
                log.error("Error writing to Graphite, clearing Graphite socket pool");
                this.pool.invalidateObject((Object)this.address, (Object)socket);
            } else {
                this.pool.returnObject((Object)this.address, (Object)socket);
            }
        }
    }

    public String getHost() {
        return this.address.getHostName();
    }

    public int getPort() {
        return this.address.getPort();
    }

    @Inject
    public void setPool(GenericKeyedObjectPool<InetSocketAddress, Socket> pool) {
        this.pool = pool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private String rootPrefix;
        private String host;
        private Integer port;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setRootPrefix(String rootPrefix) {
            this.rootPrefix = rootPrefix;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public GraphiteWriter build() {
            return new GraphiteWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.rootPrefix, this.host, this.port, null);
        }
    }
}

