/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibratoWriter
extends BaseOutputWriter {
    public static final String SETTING_URL = "url";
    public static final String SETTING_USERNAME = "username";
    public static final String SETTING_TOKEN = "token";
    public static final String SETTING_PROXY_HOST = "proxyHost";
    public static final String SETTING_PROXY_PORT = "proxyPort";
    public static final String DEFAULT_LIBRATO_API_URL = "https://metrics-api.librato.com/v1/metrics";
    public static final String SETTING_LIBRATO_API_TIMEOUT_IN_MILLIS = "libratoApiTimeoutInMillis";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JsonFactory jsonFactory = new JsonFactory();
    private final URL url;
    private final int libratoApiTimeoutInMillis;
    private final String username;
    private final String token;
    private final String basicAuthentication;
    private final String proxyHost;
    private final Integer proxyPort;
    private Proxy proxy;
    @VisibleForTesting
    final String httpUserAgent;

    @JsonCreator
    public LibratoWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="url") URL url, @JsonProperty(value="libratoApiTimeoutInMillis") Integer libratoApiTimeoutInMillis, @JsonProperty(value="username") String username, @JsonProperty(value="token") String token, @JsonProperty(value="proxyHost") String proxyHost, @JsonProperty(value="proxyPort") Integer proxyPort, @JsonProperty(value="settings") Map<String, Object> settings) throws MalformedURLException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.url = (URL)MoreObjects.firstNonNull((Object)url, (Object)new URL((String)MoreObjects.firstNonNull((Object)((String)this.getSettings().get(SETTING_URL)), (Object)DEFAULT_LIBRATO_API_URL)));
        this.libratoApiTimeoutInMillis = (Integer)MoreObjects.firstNonNull((Object)libratoApiTimeoutInMillis, (Object)Settings.getIntSetting((Map)this.getSettings(), (String)SETTING_LIBRATO_API_TIMEOUT_IN_MILLIS, (int)1000));
        this.username = (String)MoreObjects.firstNonNull((Object)username, (Object)((String)this.getSettings().get(SETTING_USERNAME)));
        this.token = (String)MoreObjects.firstNonNull((Object)token, (Object)((String)this.getSettings().get(SETTING_TOKEN)));
        this.basicAuthentication = Base64Variants.getDefaultVariant().encode((this.username + ":" + this.token).getBytes(Charsets.US_ASCII));
        this.proxyHost = proxyHost != null ? proxyHost : (String)this.getSettings().get(SETTING_PROXY_HOST);
        this.proxyPort = proxyPort != null ? proxyPort : Settings.getIntegerSetting((Map)this.getSettings(), (String)SETTING_PROXY_PORT, null);
        this.proxy = this.proxyHost != null && this.proxyPort != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort)) : null;
        this.httpUserAgent = "jmxtrans-standalone/1 (" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "/" + System.getProperty("os.version") + ")";
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        this.logger.info("Start Librato writer connected to '{}', proxy {} with username '{}' ...", new Object[]{this.url, this.proxy, this.username});
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.logger.debug("Export to '{}', proxy {} metrics {}", new Object[]{this.url, this.proxy, query});
        this.writeToLibrato(server, query, (List<Result>)results);
    }

    private void serialize(Server server, Query query, List<Result> results, OutputStream outputStream) throws IOException {
        JsonGenerator g = this.jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        g.writeStartObject();
        g.writeArrayFieldStart("counters");
        g.writeEndArray();
        String source = this.getSource(server);
        g.writeArrayFieldStart("gauges");
        List typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry values : resultValues.entrySet()) {
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                g.writeStartObject();
                g.writeStringField("name", KeyUtils.getKeyString((Query)query, (Result)result, values, (List)typeNames));
                if (source != null && !source.isEmpty()) {
                    g.writeStringField("source", source);
                }
                g.writeNumberField("measure_time", TimeUnit.SECONDS.convert(result.getEpoch(), TimeUnit.MILLISECONDS));
                Object value = values.getValue();
                if (value instanceof Integer) {
                    g.writeNumberField("value", ((Integer)value).intValue());
                } else if (value instanceof Long) {
                    g.writeNumberField("value", ((Long)value).longValue());
                } else if (value instanceof Float) {
                    g.writeNumberField("value", ((Float)value).floatValue());
                } else if (value instanceof Double) {
                    g.writeNumberField("value", ((Double)value).doubleValue());
                }
                g.writeEndObject();
            }
        }
        g.writeEndArray();
        g.writeEndObject();
        g.flush();
        g.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLibrato(Server server, Query query, List<Result> results) {
        URLConnection urlConnection = null;
        try {
            urlConnection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.libratoApiTimeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            urlConnection.setRequestProperty("User-Agent", this.httpUserAgent);
            this.serialize(server, query, results, urlConnection.getOutputStream());
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200) {
                this.logger.warn("Failure {}:'{}' to send result to Librato server '{}' with proxy {}, username {}", new Object[]{responseCode, ((HttpURLConnection)urlConnection).getResponseMessage(), this.url, this.proxy, this.username});
            }
            if (this.logger.isTraceEnabled()) {
                IOUtils.copy((InputStream)urlConnection.getInputStream(), (OutputStream)System.out);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failure to send result to Librato server '{}' with proxy {}, username {}", new Object[]{this.url, this.proxy, this.username, e});
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    IOUtils.closeQuietly((InputStream)in);
                    InputStream err = ((HttpURLConnection)urlConnection).getErrorStream();
                    if (err != null) {
                        IOUtils.copy((InputStream)err, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                        IOUtils.closeQuietly((InputStream)err);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Exception flushing http connection", (Throwable)e);
                }
            }
        }
    }

    private String getSource(Server server) {
        if (server.getAlias() != null) {
            return server.getAlias();
        }
        return StringUtils.cleanupStr((String)server.getHost());
    }

    public URL getUrl() {
        return this.url;
    }

    public int getLibratoApiTimeoutInMillis() {
        return this.libratoApiTimeoutInMillis;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }
}

