/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.NamingStrategy;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.ClassAttributeNamingStrategy;
import com.googlecode.jmxtrans.model.naming.JexlNamingStrategy;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenTSDBGenericWriter
extends BaseOutputWriter {
    public static final boolean DEFAULT_MERGE_TYPE_NAMES_TAGS = true;
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBGenericWriter.class);
    protected final String host;
    protected final Integer port;
    protected final ImmutableMap<String, String> tags;
    protected final String tagName;
    protected final NamingStrategy metricNameStrategy;
    protected final boolean mergeTypeNamesTags;
    protected final boolean addHostnameTag;
    protected final String hostnameTag;

    @JsonCreator
    public OpenTSDBGenericWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag, @JsonProperty(value="settings") Map<String, Object> settings) throws LifecycleException, UnknownHostException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.host = PropertyResolver.resolveProps((String)((String)MoreObjects.firstNonNull((Object)host, (Object)((String)this.getSettings().get("host")))));
        this.port = (Integer)MoreObjects.firstNonNull((Object)port, (Object)Settings.getIntegerSetting((Map)this.getSettings(), (String)"port", null));
        this.tags = ImmutableMap.copyOf((Map)((Map)this.firstNonNull(tags, (Map)this.getSettings().get("tags"), ImmutableMap.of())));
        this.tagName = (String)this.firstNonNull(tagName, (String)this.getSettings().get("tagName"), "type");
        this.mergeTypeNamesTags = (Boolean)MoreObjects.firstNonNull((Object)mergeTypeNamesTags, (Object)Settings.getBooleanSetting((Map)this.getSettings(), (String)"mergeTypeNamesTags", (Boolean)true));
        String jexlExpr = metricNamingExpression;
        if (jexlExpr == null) {
            jexlExpr = Settings.getStringSetting((Map)this.getSettings(), (String)"metricNamingExpression", null);
        }
        if (jexlExpr != null) {
            try {
                this.metricNameStrategy = new JexlNamingStrategy(jexlExpr);
            }
            catch (JexlException jexlExc) {
                throw new LifecycleException("failed to setup naming strategy", (Throwable)jexlExc);
            }
        } else {
            this.metricNameStrategy = new ClassAttributeNamingStrategy();
        }
        this.addHostnameTag = (Boolean)this.firstNonNull(addHostnameTag, Settings.getBooleanSetting((Map)this.getSettings(), (String)"addHostnameTag", (Boolean)this.getAddHostnameTagDefault()), this.getAddHostnameTagDefault());
        this.hostnameTag = this.addHostnameTag ? InetAddress.getLocalHost().getHostName() : null;
    }

    protected void prepareSender() throws LifecycleException {
    }

    protected void shutdownSender() throws LifecycleException {
    }

    protected void startOutput() throws IOException {
    }

    protected abstract boolean getAddHostnameTagDefault();

    protected abstract void sendOutput(String var1) throws IOException;

    protected void finishOutput() throws IOException {
    }

    void addTags(StringBuilder resultString) {
        if (this.addHostnameTag && this.hostnameTag != null) {
            this.addTag(resultString, "host", this.hostnameTag);
        }
        if (this.tags != null) {
            for (Map.Entry tagEntry : this.tags.entrySet()) {
                this.addTag(resultString, (String)tagEntry.getKey(), (String)tagEntry.getValue());
            }
        }
    }

    void addTag(StringBuilder resultString, String tagName, String tagValue) {
        resultString.append(" ");
        resultString.append(this.sanitizeString(tagName));
        resultString.append("=");
        resultString.append(this.sanitizeString(tagValue));
    }

    void formatResultString(StringBuilder resultString, String metricName, long epoch, Object value) {
        resultString.append(this.sanitizeString(metricName));
        resultString.append(" ");
        resultString.append(Long.toString(epoch));
        resultString.append(" ");
        resultString.append(this.sanitizeString(value.toString()));
    }

    List<String> resultParser(Result result) {
        String attributeName;
        LinkedList<String> resultStrings = new LinkedList<String>();
        ImmutableMap values = result.getValues();
        if (values.containsKey(attributeName = result.getAttributeName()) && values.size() == 1) {
            this.processOneMetric(resultStrings, result, values.get(attributeName), null, null);
        } else {
            for (Map.Entry valueEntry : values.entrySet()) {
                this.processOneMetric(resultStrings, result, valueEntry.getValue(), this.tagName, (String)valueEntry.getKey());
            }
        }
        return resultStrings;
    }

    protected void processOneMetric(List<String> resultStrings, Result result, Object value, String addTagName, String addTagValue) {
        String metricName = this.metricNameStrategy.formatName(result);
        if (NumberUtils.isNumeric((Object)value)) {
            StringBuilder resultString = new StringBuilder();
            this.formatResultString(resultString, metricName, result.getEpoch() / 1000L, value);
            this.addTags(resultString);
            if (addTagName != null) {
                this.addTag(resultString, addTagName, addTagValue);
            }
            if (this.getTypeNames().size() > 0) {
                this.addTypeNamesTags(resultString, result);
            }
            resultStrings.add(resultString.toString());
        } else {
            log.debug("Skipping non-numeric value for metric {}; value={}", (Object)metricName, value);
        }
    }

    protected void addTypeNamesTags(StringBuilder resultString, Result result) {
        if (this.mergeTypeNamesTags) {
            this.addTag(resultString, StringUtils.join((Collection)this.getTypeNames(), (String)""), this.getConcatedTypeNameValues(result.getTypeName()));
        } else {
            Map typeNameMap = KeyUtils.getTypeNameValueMap((String)result.getTypeName());
            for (String oneTypeName : this.getTypeNames()) {
                String value = (String)typeNameMap.get(oneTypeName);
                if (value == null) {
                    value = "";
                }
                this.addTag(resultString, oneTypeName, value);
            }
        }
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.startOutput();
        for (Result result : results) {
            for (String resultString : this.resultParser(result)) {
                if (this.isDebugEnabled()) {
                    System.out.println(resultString);
                }
                this.sendOutput(resultString);
            }
        }
        this.finishOutput();
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public void start() throws LifecycleException {
        this.prepareSender();
    }

    public void stop() throws LifecycleException {
        this.shutdownSender();
    }

    protected String sanitizeString(String unsanitized) {
        return unsanitized.replaceAll("[\"']", "").replaceAll("[^-_./a-zA-Z0-9]", "_");
    }
}

