/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensuWriter
extends BaseOutputWriter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JsonFactory jsonFactory = new JsonFactory();
    public static final String SETTING_HANDLER = "handler";
    public static final String DEFAULT_SENSU_HOST = "localhost";
    public static final String DEFAULT_SENSU_HANDLER = "graphite";
    private final String host;
    private final String handler;

    @JsonCreator
    public SensuWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="handler") String handler, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.host = (String)this.firstNonNull(host, (String)this.getSettings().get("host"), DEFAULT_SENSU_HOST);
        this.handler = (String)this.firstNonNull(handler, (String)this.getSettings().get(SETTING_HANDLER), DEFAULT_SENSU_HANDLER);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        this.logger.info("Start Sensu writer connected to '{}' with handler {}", (Object)this.host, (Object)this.handler);
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.logger.debug("Export to '{}', metrics {}", (Object)this.host, (Object)query);
        this.writeToSensu(server, query, (List<Result>)results);
    }

    private void serialize(Server server, Query query, List<Result> results, OutputStream outputStream) throws IOException {
        JsonGenerator g = this.jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        g.useDefaultPrettyPrinter();
        g.writeStartObject();
        g.writeStringField("name", "jmxtrans");
        g.writeStringField("type", "metric");
        g.writeStringField(SETTING_HANDLER, this.handler);
        StringBuilder jsonoutput = new StringBuilder();
        List typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry values : resultValues.entrySet()) {
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                Object value = values.getValue();
                jsonoutput.append(KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, null)).append(" ").append(value).append(" ").append(TimeUnit.SECONDS.convert(result.getEpoch(), TimeUnit.MILLISECONDS)).append(System.getProperty("line.separator"));
            }
        }
        g.writeStringField("output", jsonoutput.toString());
        g.writeEndObject();
        g.flush();
        g.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToSensu(Server server, Query query, List<Result> results) {
        Socket socketConnection = null;
        try {
            socketConnection = new Socket(this.host, 3030);
            this.serialize(server, query, results, socketConnection.getOutputStream());
        }
        catch (Exception e) {
            this.logger.warn("Failure to send result to Sensu server '{}'", (Object)this.host, (Object)e);
        }
        finally {
            if (socketConnection != null) {
                try {
                    socketConnection.close();
                }
                catch (IOException e) {
                    this.logger.warn("Exception closing Sensu connection", (Throwable)e);
                }
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getHandler() {
        return this.handler;
    }
}

