/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.connections.DatagramSocketFactory;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.monitoring.ManagedGenericKeyedObjectPool;
import com.googlecode.jmxtrans.monitoring.ManagedObject;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(StatsDWriter.class);
    public static final String ROOT_PREFIX = "rootPrefix";
    private final ByteBuffer sendBuffer;
    private final String bucketType;
    private final String rootPrefix;
    private final InetSocketAddress address;
    private final DatagramChannel channel = DatagramChannel.open();
    private static final String BUCKET_TYPE = "bucketType";
    private GenericKeyedObjectPool<SocketAddress, DatagramSocket> pool;
    private ManagedObject mbean;

    @JsonCreator
    public StatsDWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="bucketType") String bucketType, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="settings") Map<String, Object> settings) throws IOException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.sendBuffer = ByteBuffer.allocate(1500);
        this.bucketType = (String)this.firstNonNull(bucketType, (String)this.getSettings().get(BUCKET_TYPE), "c");
        this.rootPrefix = (String)this.firstNonNull(rootPrefix, (String)this.getSettings().get(ROOT_PREFIX), "servers");
        if (host == null) {
            host = (String)this.getSettings().get("host");
        }
        if (port == null) {
            port = Settings.getIntegerSetting((Map)this.getSettings(), (String)"port", null);
        }
        Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null");
        Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null");
        this.address = new InetSocketAddress(host, (int)port);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public void start() throws LifecycleException {
        try {
            this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new DatagramSocketFactory());
            this.pool.setTestOnBorrow(true);
            this.pool.setMaxActive(-1);
            this.pool.setMaxIdle(-1);
            this.pool.setTimeBetweenEvictionRunsMillis(300000L);
            this.pool.setMinEvictableIdleTimeMillis(300000L);
            this.mbean = new ManagedGenericKeyedObjectPool(this.pool, "StatsdConnectionPool");
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.mbean, this.mbean.getObjectName());
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            if (this.mbean != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.unregisterMBean(this.mbean.getObjectName());
                this.mbean = null;
            }
            if (this.pool != null) {
                this.pool.close();
                this.pool = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        List typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues;
            if (this.isDebugEnabled()) {
                log.debug(result.toString());
            }
            if ((resultValues = result.getValues()) == null) continue;
            for (Map.Entry values : resultValues.entrySet()) {
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                String line = KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, (List)typeNames, (String)this.rootPrefix) + ":" + values.getValue().toString() + "|" + this.bucketType + "\n";
                if (this.isDebugEnabled()) {
                    log.debug("StatsD Message: " + line.trim());
                }
                this.doSend(line.trim());
            }
        }
    }

    private synchronized boolean doSend(String stat) {
        try {
            byte[] data = stat.getBytes("utf-8");
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.flush();
            }
            if (this.sendBuffer.position() > 0) {
                this.sendBuffer.put((byte)10);
            }
            this.sendBuffer.put(data);
            this.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized boolean flush() {
        try {
            int sizeOfBuffer = this.sendBuffer.position();
            if (sizeOfBuffer <= 0) {
                return false;
            }
            this.sendBuffer.flip();
            int nbSentBytes = this.channel.send(this.sendBuffer, this.address);
            this.sendBuffer.limit(this.sendBuffer.capacity());
            this.sendBuffer.rewind();
            return sizeOfBuffer == nbSentBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getBucketType() {
        return this.bucketType;
    }

    public String getHostname() {
        return this.address.getHostName();
    }

    public int getPort() {
        return this.address.getPort();
    }
}

