/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.TcpOutputWriter;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GraphiteWriterFactory
implements OutputWriterFactory {
    private static final String DEFAULT_ROOT_PREFIX = "servers";
    private final String rootPrefix;
    private final InetSocketAddress graphiteServer;
    private final ImmutableList<String> typeNames;
    private final boolean booleanAsNumber;

    @JsonCreator
    public GraphiteWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port) {
        this.typeNames = typeNames;
        this.booleanAsNumber = booleanAsNumber;
        this.rootPrefix = (String)MoreObjects.firstNonNull((Object)rootPrefix, (Object)DEFAULT_ROOT_PREFIX);
        this.graphiteServer = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
    }

    public ResultTransformerOutputWriter<TcpOutputWriter<GraphiteWriter2>> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, TcpOutputWriter.builder(this.graphiteServer, new GraphiteWriter2(this.typeNames, this.rootPrefix)).setCharset(Charsets.UTF_8).build());
    }
}

