/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.LibratoWriter2;
import com.googlecode.jmxtrans.model.output.support.HttpOutputWriter;
import com.googlecode.jmxtrans.model.output.support.HttpUrlConnectionConfigurer;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LibratoWriterFactory
implements OutputWriterFactory {
    private final boolean booleanAsNumber;
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nonnull
    private final URL url;
    @Nullable
    private final Proxy proxy;
    @Nonnull
    private final int readTimeoutInMillis;
    @Nullable
    private final String authorization;

    public LibratoWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="url") URL url, @JsonProperty(value="libratoApiTimeoutInMillis") Integer readTimeoutInMillis, @JsonProperty(value="username") String username, @JsonProperty(value="token") String token, @JsonProperty(value="proxyHost") String proxyHost, @JsonProperty(value="proxyPort") Integer proxyPort) {
        this.booleanAsNumber = booleanAsNumber;
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.url = (URL)Preconditions.checkNotNull((Object)url);
        this.readTimeoutInMillis = (Integer)MoreObjects.firstNonNull((Object)readTimeoutInMillis, (Object)1000);
        this.authorization = "Basic" + Base64Variants.getDefaultVariant().encode(((String)Preconditions.checkNotNull((Object)username) + ":" + (String)Preconditions.checkNotNull((Object)token)).getBytes(Charsets.US_ASCII));
        this.proxy = this.initProxy(proxyHost, proxyPort);
    }

    private Proxy initProxy(String proxyHost, Integer proxyPort) {
        if (proxyHost == null) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)((Integer)Preconditions.checkNotNull((Object)proxyPort, (Object)"Proxy port needs to be specified."))));
    }

    public ResultTransformerOutputWriter<HttpOutputWriter<LibratoWriter2>> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, new HttpOutputWriter<LibratoWriter2>(new LibratoWriter2(new JsonFactory(), this.typeNames), this.url, this.proxy, new HttpUrlConnectionConfigurer("POST", this.readTimeoutInMillis, this.authorization, "application/json; charset=utf-8"), Charsets.UTF_8));
    }
}

